/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketSession
extends AbstractListenerWebSocketSession<Session> {
    @Nullable
    private volatile SuspendToken suspendToken;

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, null);
    }

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(session, ObjectUtils.getIdentityHexString((Object)session), info, factory, completionSink);
    }

    @Override
    protected boolean canSuspendReceiving() {
        return true;
    }

    @Override
    protected void suspendReceiving() {
        Assert.state((this.suspendToken == null ? 1 : 0) != 0, (String)"Already suspended");
        this.suspendToken = ((Session)this.getDelegate()).suspend();
    }

    @Override
    protected void resumeReceiving() {
        SuspendToken tokenToUse = this.suspendToken;
        this.suspendToken = null;
        if (tokenToUse != null) {
            tokenToUse.resume();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        DataBuffer dataBuffer = message.getPayload();
        RemoteEndpoint remote = ((Session)this.getDelegate()).getRemote();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = dataBuffer.toString(StandardCharsets.UTF_8);
            remote.sendString(text, (WriteCallback)new SendProcessorCallback());
            return true;
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
        }
        try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
            block10: while (iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                switch (message.getType()) {
                    case BINARY: {
                        remote.sendBytes(byteBuffer, (WriteCallback)new SendProcessorCallback());
                        continue block10;
                    }
                    case PING: {
                        remote.sendPing(byteBuffer);
                        continue block10;
                    }
                    case PONG: {
                        remote.sendPong(byteBuffer);
                        continue block10;
                    }
                }
            }
            return true;
            throw new IllegalArgumentException("Unexpected message type: " + message.getType());
        }
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        ((Session)this.getDelegate()).close(status.getCode(), status.getReason());
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements WriteCallback {
        private SendProcessorCallback() {
        }

        public void writeFailed(Throwable x) {
            JettyWebSocketSession.this.getSendProcessor().cancel();
            JettyWebSocketSession.this.getSendProcessor().onError(x);
        }

        public void writeSuccess() {
            JettyWebSocketSession.this.getSendProcessor().setReadyToSend(true);
            JettyWebSocketSession.this.getSendProcessor().onWritePossible();
        }
    }
}

