/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.HeadersRequestCondition;
import org.springframework.web.reactive.result.condition.ParamsRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.reactive.result.condition.RequestConditionHolder;
import org.springframework.web.reactive.result.condition.RequestMethodsRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class RequestMappingInfo
implements RequestCondition<RequestMappingInfo> {
    private static final PatternsRequestCondition EMPTY_PATTERNS = new PatternsRequestCondition(new PathPattern[0]);
    private static final RequestMethodsRequestCondition EMPTY_REQUEST_METHODS = new RequestMethodsRequestCondition(new RequestMethod[0]);
    private static final ParamsRequestCondition EMPTY_PARAMS = new ParamsRequestCondition(new String[0]);
    private static final HeadersRequestCondition EMPTY_HEADERS = new HeadersRequestCondition(new String[0]);
    private static final ConsumesRequestCondition EMPTY_CONSUMES = new ConsumesRequestCondition(new String[0]);
    private static final ProducesRequestCondition EMPTY_PRODUCES = new ProducesRequestCondition(new String[0]);
    private static final RequestConditionHolder EMPTY_CUSTOM = new RequestConditionHolder(null);
    @Nullable
    private final String name;
    private final PatternsRequestCondition patternsCondition;
    private final RequestMethodsRequestCondition methodsCondition;
    private final ParamsRequestCondition paramsCondition;
    private final HeadersRequestCondition headersCondition;
    private final ConsumesRequestCondition consumesCondition;
    private final ProducesRequestCondition producesCondition;
    private final RequestConditionHolder customConditionHolder;
    private final int hashCode;
    private final BuilderConfiguration options;

    @Deprecated
    public RequestMappingInfo(@Nullable String name, @Nullable PatternsRequestCondition patterns, @Nullable RequestMethodsRequestCondition methods, @Nullable ParamsRequestCondition params, @Nullable HeadersRequestCondition headers, @Nullable ConsumesRequestCondition consumes, @Nullable ProducesRequestCondition produces, @Nullable RequestCondition<?> custom) {
        this(name, patterns, methods, params, headers, consumes, produces, custom, new BuilderConfiguration());
    }

    @Deprecated
    public RequestMappingInfo(@Nullable PatternsRequestCondition patterns, @Nullable RequestMethodsRequestCondition methods, @Nullable ParamsRequestCondition params, @Nullable HeadersRequestCondition headers, @Nullable ConsumesRequestCondition consumes, @Nullable ProducesRequestCondition produces, @Nullable RequestCondition<?> custom) {
        this(null, patterns, methods, params, headers, consumes, produces, custom);
    }

    @Deprecated
    public RequestMappingInfo(RequestMappingInfo info, @Nullable RequestCondition<?> customRequestCondition) {
        this(info.name, info.patternsCondition, info.methodsCondition, info.paramsCondition, info.headersCondition, info.consumesCondition, info.producesCondition, customRequestCondition);
    }

    private RequestMappingInfo(@Nullable String name, @Nullable PatternsRequestCondition patterns, @Nullable RequestMethodsRequestCondition methods, @Nullable ParamsRequestCondition params, @Nullable HeadersRequestCondition headers, @Nullable ConsumesRequestCondition consumes, @Nullable ProducesRequestCondition produces, @Nullable RequestCondition<?> custom, BuilderConfiguration options) {
        this.name = StringUtils.hasText((String)name) ? name : null;
        this.patternsCondition = patterns != null ? patterns : EMPTY_PATTERNS;
        this.methodsCondition = methods != null ? methods : EMPTY_REQUEST_METHODS;
        this.paramsCondition = params != null ? params : EMPTY_PARAMS;
        this.headersCondition = headers != null ? headers : EMPTY_HEADERS;
        this.consumesCondition = consumes != null ? consumes : EMPTY_CONSUMES;
        this.producesCondition = produces != null ? produces : EMPTY_PRODUCES;
        this.customConditionHolder = custom != null ? new RequestConditionHolder(custom) : EMPTY_CUSTOM;
        this.options = options;
        this.hashCode = RequestMappingInfo.calculateHashCode(this.patternsCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, this.customConditionHolder);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.patternsCondition;
    }

    public Set<String> getDirectPaths() {
        return this.patternsCondition.getDirectPaths();
    }

    public RequestMethodsRequestCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public ParamsRequestCondition getParamsCondition() {
        return this.paramsCondition;
    }

    public HeadersRequestCondition getHeadersCondition() {
        return this.headersCondition;
    }

    public ConsumesRequestCondition getConsumesCondition() {
        return this.consumesCondition;
    }

    public ProducesRequestCondition getProducesCondition() {
        return this.producesCondition;
    }

    @Nullable
    public RequestCondition<?> getCustomCondition() {
        return this.customConditionHolder.getCondition();
    }

    @Override
    public RequestMappingInfo combine(RequestMappingInfo other) {
        String name = this.combineNames(other);
        PatternsRequestCondition patterns = this.patternsCondition.combine(other.patternsCondition);
        RequestMethodsRequestCondition methods = this.methodsCondition.combine(other.methodsCondition);
        ParamsRequestCondition params = this.paramsCondition.combine(other.paramsCondition);
        HeadersRequestCondition headers = this.headersCondition.combine(other.headersCondition);
        ConsumesRequestCondition consumes = this.consumesCondition.combine(other.consumesCondition);
        ProducesRequestCondition produces = this.producesCondition.combine(other.producesCondition);
        RequestConditionHolder custom = this.customConditionHolder.combine(other.customConditionHolder);
        return new RequestMappingInfo(name, patterns, methods, params, headers, consumes, produces, custom.getCondition(), this.options);
    }

    @Nullable
    private String combineNames(RequestMappingInfo other) {
        if (this.name != null && other.name != null) {
            return this.name + "#" + other.name;
        }
        if (this.name != null) {
            return this.name;
        }
        return other.name;
    }

    @Override
    @Nullable
    public RequestMappingInfo getMatchingCondition(ServerWebExchange exchange) {
        RequestMethodsRequestCondition methods = this.methodsCondition.getMatchingCondition(exchange);
        if (methods == null) {
            return null;
        }
        ParamsRequestCondition params = this.paramsCondition.getMatchingCondition(exchange);
        if (params == null) {
            return null;
        }
        HeadersRequestCondition headers = this.headersCondition.getMatchingCondition(exchange);
        if (headers == null) {
            return null;
        }
        ConsumesRequestCondition consumes = this.consumesCondition.getMatchingCondition(exchange);
        if (consumes == null) {
            return null;
        }
        ProducesRequestCondition produces = this.producesCondition.getMatchingCondition(exchange);
        if (produces == null) {
            return null;
        }
        PatternsRequestCondition patterns = this.patternsCondition.getMatchingCondition(exchange);
        if (patterns == null) {
            return null;
        }
        RequestConditionHolder custom = this.customConditionHolder.getMatchingCondition(exchange);
        if (custom == null) {
            return null;
        }
        return new RequestMappingInfo(this.name, patterns, methods, params, headers, consumes, produces, custom.getCondition(), this.options);
    }

    @Override
    public int compareTo(RequestMappingInfo other, ServerWebExchange exchange) {
        int result = this.patternsCondition.compareTo(other.getPatternsCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.paramsCondition.compareTo(other.getParamsCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.headersCondition.compareTo(other.getHeadersCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.consumesCondition.compareTo(other.getConsumesCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.producesCondition.compareTo(other.getProducesCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.methodsCondition.compareTo(other.getMethodsCondition(), exchange);
        if (result != 0) {
            return result;
        }
        result = this.customConditionHolder.compareTo(other.customConditionHolder, exchange);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingInfo)) {
            return false;
        }
        RequestMappingInfo otherInfo = (RequestMappingInfo)other;
        return this.patternsCondition.equals(otherInfo.patternsCondition) && this.methodsCondition.equals(otherInfo.methodsCondition) && this.paramsCondition.equals(otherInfo.paramsCondition) && this.headersCondition.equals(otherInfo.headersCondition) && this.consumesCondition.equals(otherInfo.consumesCondition) && this.producesCondition.equals(otherInfo.producesCondition) && this.customConditionHolder.equals(otherInfo.customConditionHolder);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int calculateHashCode(PatternsRequestCondition patterns, RequestMethodsRequestCondition methods, ParamsRequestCondition params, HeadersRequestCondition headers, ConsumesRequestCondition consumes, ProducesRequestCondition produces, RequestConditionHolder custom) {
        return patterns.hashCode() * 31 + methods.hashCode() + params.hashCode() + headers.hashCode() + consumes.hashCode() + produces.hashCode() + custom.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.methodsCondition.isEmpty()) {
            RequestMethod httpMethods = this.methodsCondition.getMethods();
            builder.append(httpMethods.size() == 1 ? httpMethods.iterator().next() : httpMethods);
        }
        if (!this.patternsCondition.isEmpty()) {
            PathPattern patterns = this.patternsCondition.getPatterns();
            builder.append(' ').append(patterns.size() == 1 ? patterns.iterator().next() : patterns);
        }
        if (!this.paramsCondition.isEmpty()) {
            builder.append(", params ").append(this.paramsCondition);
        }
        if (!this.headersCondition.isEmpty()) {
            builder.append(", headers ").append(this.headersCondition);
        }
        if (!this.consumesCondition.isEmpty()) {
            builder.append(", consumes ").append(this.consumesCondition);
        }
        if (!this.producesCondition.isEmpty()) {
            builder.append(", produces ").append(this.producesCondition);
        }
        if (!this.customConditionHolder.isEmpty()) {
            builder.append(", and ").append(this.customConditionHolder);
        }
        builder.append('}');
        return builder.toString();
    }

    public Builder mutate() {
        return new MutateBuilder(this);
    }

    public static Builder paths(String ... paths) {
        return new DefaultBuilder(paths);
    }

    public static class BuilderConfiguration {
        @Nullable
        private PathPatternParser patternParser;
        @Nullable
        private RequestedContentTypeResolver contentTypeResolver;

        public void setPatternParser(PathPatternParser patternParser) {
            this.patternParser = patternParser;
        }

        @Nullable
        public PathPatternParser getPatternParser() {
            return this.patternParser;
        }

        public void setContentTypeResolver(RequestedContentTypeResolver resolver) {
            this.contentTypeResolver = resolver;
        }

        @Nullable
        public RequestedContentTypeResolver getContentTypeResolver() {
            return this.contentTypeResolver;
        }
    }

    private static class MutateBuilder
    implements Builder {
        @Nullable
        private String name;
        @Nullable
        private PatternsRequestCondition patternsCondition;
        private RequestMethodsRequestCondition methodsCondition;
        private ParamsRequestCondition paramsCondition;
        private HeadersRequestCondition headersCondition;
        private ConsumesRequestCondition consumesCondition;
        private ProducesRequestCondition producesCondition;
        private RequestConditionHolder customConditionHolder;
        private BuilderConfiguration options;

        public MutateBuilder(RequestMappingInfo other) {
            this.name = other.name;
            this.patternsCondition = other.patternsCondition;
            this.methodsCondition = other.methodsCondition;
            this.paramsCondition = other.paramsCondition;
            this.headersCondition = other.headersCondition;
            this.consumesCondition = other.consumesCondition;
            this.producesCondition = other.producesCondition;
            this.customConditionHolder = other.customConditionHolder;
            this.options = other.options;
        }

        @Override
        public Builder paths(String ... paths) {
            PathPatternParser parser = this.options.getPatternParser() != null ? this.options.getPatternParser() : PathPatternParser.defaultInstance;
            this.patternsCondition = DefaultBuilder.isEmpty(paths) ? null : new PatternsRequestCondition(DefaultBuilder.parse(paths, parser));
            return this;
        }

        @Override
        public Builder methods(RequestMethod ... methods) {
            this.methodsCondition = ObjectUtils.isEmpty((Object[])methods) ? EMPTY_REQUEST_METHODS : new RequestMethodsRequestCondition(methods);
            return this;
        }

        @Override
        public Builder params(String ... params) {
            this.paramsCondition = ObjectUtils.isEmpty((Object[])params) ? EMPTY_PARAMS : new ParamsRequestCondition(params);
            return this;
        }

        @Override
        public Builder headers(String ... headers) {
            this.headersCondition = ObjectUtils.isEmpty((Object[])headers) ? EMPTY_HEADERS : new HeadersRequestCondition(headers);
            return this;
        }

        @Override
        public Builder consumes(String ... consumes) {
            this.consumesCondition = ObjectUtils.isEmpty((Object[])consumes) ? EMPTY_CONSUMES : new ConsumesRequestCondition(consumes);
            return this;
        }

        @Override
        public Builder produces(String ... produces) {
            this.producesCondition = ObjectUtils.isEmpty((Object[])produces) ? EMPTY_PRODUCES : new ProducesRequestCondition(produces, null, this.options.getContentTypeResolver());
            return this;
        }

        @Override
        public Builder mappingName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder customCondition(RequestCondition<?> condition) {
            this.customConditionHolder = new RequestConditionHolder(condition);
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            return new RequestMappingInfo(this.name, this.patternsCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, this.customConditionHolder, this.options);
        }
    }

    private static class DefaultBuilder
    implements Builder {
        private String[] paths;
        @Nullable
        private RequestMethod[] methods;
        @Nullable
        private String[] params;
        @Nullable
        private String[] headers;
        @Nullable
        private String[] consumes;
        @Nullable
        private String[] produces;
        private boolean hasContentType;
        private boolean hasAccept;
        @Nullable
        private String mappingName;
        @Nullable
        private RequestCondition<?> customCondition;
        private BuilderConfiguration options = new BuilderConfiguration();

        public DefaultBuilder(String ... paths) {
            this.paths = paths;
        }

        @Override
        public Builder paths(String ... paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public DefaultBuilder methods(RequestMethod ... methods) {
            this.methods = methods;
            return this;
        }

        @Override
        public DefaultBuilder params(String ... params) {
            this.params = params;
            return this;
        }

        @Override
        public DefaultBuilder headers(String ... headers) {
            for (String header : headers) {
                this.hasContentType = this.hasContentType || header.contains("Content-Type") || header.contains("content-type");
                this.hasAccept = this.hasAccept || header.contains("Accept") || header.contains("accept");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public DefaultBuilder consumes(String ... consumes) {
            this.consumes = consumes;
            return this;
        }

        @Override
        public DefaultBuilder produces(String ... produces) {
            this.produces = produces;
            return this;
        }

        @Override
        public DefaultBuilder mappingName(String name) {
            this.mappingName = name;
            return this;
        }

        @Override
        public DefaultBuilder customCondition(RequestCondition<?> condition) {
            this.customCondition = condition;
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            PathPatternParser parser = this.options.getPatternParser() != null ? this.options.getPatternParser() : PathPatternParser.defaultInstance;
            RequestedContentTypeResolver contentTypeResolver = this.options.getContentTypeResolver();
            return new RequestMappingInfo(this.mappingName, DefaultBuilder.isEmpty(this.paths) ? null : new PatternsRequestCondition(DefaultBuilder.parse(this.paths, parser)), ObjectUtils.isEmpty((Object[])this.methods) ? null : new RequestMethodsRequestCondition(this.methods), ObjectUtils.isEmpty((Object[])this.params) ? null : new ParamsRequestCondition(this.params), ObjectUtils.isEmpty((Object[])this.headers) ? null : new HeadersRequestCondition(this.headers), (ConsumesRequestCondition)(ObjectUtils.isEmpty((Object[])this.consumes) && !this.hasContentType ? null : new ConsumesRequestCondition(this.consumes, this.headers)), (ProducesRequestCondition)(ObjectUtils.isEmpty((Object[])this.produces) && !this.hasAccept ? null : new ProducesRequestCondition(this.produces, this.headers, contentTypeResolver)), this.customCondition, this.options);
        }

        /*
         * WARNING - void declaration
         */
        static List<PathPattern> parse(String[] patterns, PathPatternParser parser) {
            if (DefaultBuilder.isEmpty(patterns)) {
                return Collections.emptyList();
            }
            ArrayList<PathPattern> result = new ArrayList<PathPattern>(patterns.length);
            for (String string : patterns) {
                void var6_6;
                if (StringUtils.hasText((String)string) && !string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                result.add(parser.parse((String)var6_6));
            }
            return result;
        }

        static boolean isEmpty(String[] patterns) {
            if (!ObjectUtils.isEmpty((Object[])patterns)) {
                for (String pattern : patterns) {
                    if (!StringUtils.hasText((String)pattern)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static interface Builder {
        public Builder paths(String ... var1);

        public Builder methods(RequestMethod ... var1);

        public Builder params(String ... var1);

        public Builder headers(String ... var1);

        public Builder consumes(String ... var1);

        public Builder produces(String ... var1);

        public Builder mappingName(String var1);

        public Builder customCondition(RequestCondition<?> var1);

        public Builder options(BuilderConfiguration var1);

        public RequestMappingInfo build();
    }
}

