/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.util.UriComponentsBuilder;

final class DefaultApiVersionInserter
implements ApiVersionInserter {
    private final @Nullable String header;
    private final @Nullable String queryParam;
    private final @Nullable String mediaTypeParam;
    private final @Nullable Integer pathSegmentIndex;
    private final ApiVersionFormatter versionFormatter;

    DefaultApiVersionInserter(@Nullable String header, @Nullable String queryParam, @Nullable String mediaTypeParam, @Nullable Integer pathSegmentIndex, @Nullable ApiVersionFormatter formatter) {
        Assert.isTrue((header != null || queryParam != null || mediaTypeParam != null || pathSegmentIndex != null ? 1 : 0) != 0, (String)"Expected 'header', 'queryParam', 'mediaTypeParam', or 'pathSegmentIndex' to be configured");
        this.header = header;
        this.queryParam = queryParam;
        this.mediaTypeParam = mediaTypeParam;
        this.pathSegmentIndex = pathSegmentIndex;
        this.versionFormatter = formatter != null ? formatter : Object::toString;
    }

    @Override
    public URI insertVersion(Object version, URI uri) {
        if (this.queryParam == null && this.pathSegmentIndex == null) {
            return uri;
        }
        String formattedVersion = this.versionFormatter.formatVersion(version);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri(uri);
        if (this.queryParam != null) {
            builder.queryParam(this.queryParam, formattedVersion);
        }
        if (this.pathSegmentIndex != null) {
            ArrayList<String> pathSegments = new ArrayList<String>(builder.build().getPathSegments());
            this.assertPathSegmentIndex(this.pathSegmentIndex, pathSegments.size(), uri);
            pathSegments.add(this.pathSegmentIndex, formattedVersion);
            builder.replacePath(null);
            UriComponentsBuilder uriComponentsBuilder = builder;
            Objects.requireNonNull(uriComponentsBuilder);
            UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder;
            pathSegments.forEach(xva$0 -> uriComponentsBuilder2.pathSegment((String)xva$0));
        }
        return builder.build(true).toUri();
    }

    private void assertPathSegmentIndex(Integer index, int pathSegmentsSize, URI uri) {
        Assert.state((index <= pathSegmentsSize ? 1 : 0) != 0, (String)("Cannot insert version into '" + uri.getPath() + "' at path segment index " + index));
    }

    @Override
    public void insertVersion(Object version, HttpHeaders headers) {
        MediaType contentType;
        if (this.header != null) {
            String formattedVersion = this.versionFormatter.formatVersion(version);
            headers.set(this.header, formattedVersion);
        }
        if (this.mediaTypeParam != null && (contentType = headers.getContentType()) != null) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(contentType.getParameters());
            params.put(this.mediaTypeParam, this.versionFormatter.formatVersion(version));
            contentType = new MediaType(contentType, params);
            headers.setContentType(contentType);
        }
    }
}

