/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.OutputStreamRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.JettyClientHttpResponse;
import org.springframework.util.StreamUtils;

class JettyClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private static final int CHUNK_SIZE = 1024;
    private final Request request;
    private final long readTimeout;

    public JettyClientHttpRequest(Request request, long readTimeout) {
        this.request = request;
        this.readTimeout = readTimeout;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.getMethod());
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        if (!headers.isEmpty()) {
            this.request.headers(httpFields -> headers.forEach((headerName, headerValues) -> {
                for (String headerValue : headerValues) {
                    httpFields.add(headerName, headerValue);
                }
            }));
        }
        String contentType = null;
        if (headers.getContentType() != null) {
            contentType = headers.getContentType().toString();
        }
        try {
            InputStreamResponseListener responseListener = new InputStreamResponseListener();
            if (body2 != null) {
                OutputStreamRequestContent requestContent = new OutputStreamRequestContent(contentType);
                this.request.body((Request.Content)requestContent).send((Response.CompleteListener)responseListener);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(requestContent.getOutputStream(), 1024);){
                    body2.writeTo(StreamUtils.nonClosing((OutputStream)outputStream));
                }
            } else {
                this.request.send((Response.CompleteListener)responseListener);
            }
            Response response = responseListener.get(this.readTimeout, TimeUnit.MILLISECONDS);
            return new JettyClientHttpResponse(response, responseListener.getInputStream());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Request was interrupted: " + ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof UncheckedIOException) {
                UncheckedIOException uioEx = (UncheckedIOException)cause;
                throw uioEx.getCause();
            }
            if (cause instanceof RuntimeException) {
                RuntimeException rtEx = (RuntimeException)cause;
                throw rtEx;
            }
            if (cause instanceof IOException) {
                IOException ioEx = (IOException)cause;
                throw ioEx;
            }
            String message = cause == null ? null : cause.getMessage();
            throw message == null ? new IOException(cause) : new IOException(message, cause);
        }
        catch (TimeoutException ex) {
            throw new IOException("Request timed out: " + ex.getMessage(), ex);
        }
    }
}

