/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestClient;

public class ExchangeResult {
    private static final Pattern SAME_SITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");
    private static final Pattern PARTITIONED_PATTERN = Pattern.compile("(?i).*;\\s*Partitioned(\\s*;.*|\\s*)$");
    private static final List<MediaType> PRINTABLE_MEDIA_TYPES = List.of(MediaType.parseMediaType((String)"application/*+json"), MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"text/*"), MediaType.APPLICATION_FORM_URLENCODED);
    private static final Log logger = LogFactory.getLog(ExchangeResult.class);
    private final HttpRequest request;
    private final RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientResponse;
    private final @Nullable String uriTemplate;
    private final byte[] requestBody;
    private final @Nullable HttpMessageContentConverter messageContentConverter;
    private boolean diagnosticsLogged;

    ExchangeResult(HttpRequest request, RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse response, @Nullable String uriTemplate, byte[] requestBody, @Nullable HttpMessageContentConverter messageContentConverter) {
        Assert.notNull((Object)request, (String)"HttpRequest must not be null");
        Assert.notNull((Object)response, (String)"ClientHttpResponse must not be null");
        this.request = request;
        this.clientResponse = response;
        this.uriTemplate = uriTemplate;
        this.requestBody = requestBody;
        this.messageContentConverter = messageContentConverter;
    }

    ExchangeResult(ExchangeResult result) {
        this(result.request, result.clientResponse, result.uriTemplate, result.requestBody, result.messageContentConverter);
        this.diagnosticsLogged = result.diagnosticsLogged;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getUrl() {
        return this.request.getURI();
    }

    public @Nullable String getUriTemplate() {
        return this.uriTemplate;
    }

    public HttpHeaders getRequestHeaders() {
        return this.request.getHeaders();
    }

    public HttpStatusCode getStatus() {
        try {
            return this.clientResponse.getStatusCode();
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public HttpHeaders getResponseHeaders() {
        return this.clientResponse.getHeaders();
    }

    public MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return (MultiValueMap)Optional.ofNullable(this.clientResponse.getHeaders().get("Set-Cookie")).orElse(List.of()).stream().flatMap(header -> {
            Matcher matcher = SAME_SITE_PATTERN.matcher((CharSequence)header);
            String sameSite = matcher.matches() ? matcher.group(1) : null;
            boolean partitioned = PARTITIONED_PATTERN.matcher((CharSequence)header).matches();
            return HttpCookie.parse(header).stream().map(cookie -> ExchangeResult.toResponseCookie(cookie, sameSite, partitioned));
        }).collect(LinkedMultiValueMap::new, (cookies, cookie) -> cookies.add((Object)cookie.getName(), cookie), MultiValueMapAdapter::addAll);
    }

    private static ResponseCookie toResponseCookie(HttpCookie cookie, @Nullable String sameSite, boolean partitioned) {
        return ResponseCookie.from((String)cookie.getName(), (String)cookie.getValue()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly()).maxAge(cookie.getMaxAge()).path(cookie.getPath()).secure(cookie.getSecure()).sameSite(sameSite).partitioned(partitioned).build();
    }

    public byte[] getRequestBodyContent() {
        return this.requestBody;
    }

    RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse getClientResponse() {
        return this.clientResponse;
    }

    public byte[] getResponseBodyContent() {
        try {
            return StreamUtils.copyToByteArray((InputStream)this.clientResponse.getBody());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to get response content: " + String.valueOf(ex));
        }
    }

    public @Nullable HttpMessageContentConverter getMessageContentConverter() {
        return this.messageContentConverter;
    }

    public void assertWithDiagnostics(Runnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError ex) {
            if (!this.diagnosticsLogged && logger.isErrorEnabled()) {
                this.diagnosticsLogged = true;
                logger.error((Object)("Request details for assertion failure:\n" + String.valueOf(this)));
            }
            throw ex;
        }
    }

    public String toString() {
        return "\n> " + String.valueOf(this.getMethod()) + " " + String.valueOf(this.getUrl()) + "\n> " + this.formatHeaders(this.getRequestHeaders(), "\n> ") + "\n\n" + this.formatBody(this.getRequestHeaders().getContentType(), this.requestBody) + "\n\n< " + this.formatStatus(this.getStatus()) + "\n< " + this.formatHeaders(this.getResponseHeaders(), "\n< ") + "\n\n" + this.formatBody(this.getResponseHeaders().getContentType(), this.getResponseBodyContent()) + "\n";
    }

    private String formatStatus(HttpStatusCode statusCode) {
        Object result = statusCode.toString();
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            result = (String)result + " " + status.getReasonPhrase();
        }
        return result;
    }

    private String formatHeaders(HttpHeaders headers, String delimiter) {
        return headers.headerSet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(delimiter));
    }

    private String formatBody(@Nullable MediaType contentType, byte[] bytes) {
        if (contentType == null) {
            return bytes.length + " bytes of content (unknown content-type).";
        }
        Charset charset = contentType.getCharset();
        if (charset != null) {
            return new String(bytes, charset);
        }
        if (PRINTABLE_MEDIA_TYPES.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return bytes.length + " bytes of content.";
    }
}

