/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.result.XpathResultMatchers;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001BI\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u0012\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u0010\u0015\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u0014\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001aJ\u0014\u0010\u001c\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0005J\u0014\u0010\u001e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0013J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/springframework/test/web/servlet/result/XpathResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "expression", "", "namespaces", "", "args", "", "<init>", "(Lorg/springframework/test/web/servlet/ResultActions;Ljava/lang/String;Ljava/util/Map;[Ljava/lang/Object;)V", "matchers", "Lorg/springframework/test/web/servlet/result/XpathResultMatchers;", "kotlin.jvm.PlatformType", "Lorg/springframework/test/web/servlet/result/XpathResultMatchers;", "node", "", "matcher", "Lorg/hamcrest/Matcher;", "Lorg/w3c/dom/Node;", "nodeList", "Lorg/w3c/dom/NodeList;", "exists", "doesNotExist", "nodeCount", "", "expectedCount", "string", "expectedValue", "number", "", "booleanValue", "value", "", "spring-test"})
public final class XpathResultMatchersDsl {
    @NotNull
    private final ResultActions actions;
    private final XpathResultMatchers matchers;

    public XpathResultMatchersDsl(@NotNull ResultActions actions, @NotNull String expression, @Nullable Map<String, String> namespaces, Object ... args) {
        XpathResultMatchers xpathResultMatchers;
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.actions = actions;
        Map<String, String> map = namespaces;
        if (map == null) {
            Object[] objectArray = new Object[]{args};
            xpathResultMatchers = MockMvcResultMatchers.xpath(expression, objectArray);
        } else {
            Object[] objectArray = new Object[]{args};
            xpathResultMatchers = MockMvcResultMatchers.xpath(expression, map, objectArray);
        }
        this.matchers = xpathResultMatchers;
    }

    public /* synthetic */ XpathResultMatchersDsl(ResultActions resultActions, String string, Map map, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        this(resultActions, string, (Map<String, String>)map, objectArray);
    }

    public final void node(@NotNull Matcher<Node> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.node(matcher));
    }

    public final void nodeList(@NotNull Matcher<NodeList> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.nodeList(matcher));
    }

    public final void exists() {
        this.actions.andExpect(this.matchers.exists());
    }

    public final void doesNotExist() {
        this.actions.andExpect(this.matchers.doesNotExist());
    }

    public final void nodeCount(@NotNull Matcher<Integer> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.nodeCount(matcher));
    }

    public final void nodeCount(int expectedCount) {
        this.actions.andExpect(this.matchers.nodeCount(expectedCount));
    }

    public final void string(@NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.string(matcher));
    }

    public final void string(@NotNull String expectedValue) {
        Intrinsics.checkNotNullParameter((Object)expectedValue, (String)"expectedValue");
        this.actions.andExpect(this.matchers.string(expectedValue));
    }

    public final void number(@NotNull Matcher<Double> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.number(matcher));
    }

    public final void number(double expectedValue) {
        this.actions.andExpect(this.matchers.number(expectedValue));
    }

    public final void booleanValue(boolean value) {
        this.actions.andExpect(this.matchers.booleanValue(value));
    }
}

