/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessageReceivingOperations;

public abstract class AbstractMessageReceivingTemplate<D>
extends AbstractMessageSendingTemplate<D>
implements MessageReceivingOperations<D> {
    @Override
    public @Nullable Message<?> receive() throws MessagingException {
        return this.doReceive(this.getRequiredDefaultDestination());
    }

    @Override
    public @Nullable Message<?> receive(D destination) throws MessagingException {
        return this.doReceive(destination);
    }

    @Override
    public <T> @Nullable T receiveAndConvert(Class<T> targetClass) throws MessagingException {
        return this.receiveAndConvert(this.getRequiredDefaultDestination(), targetClass);
    }

    @Override
    public <T> @Nullable T receiveAndConvert(D destination, Class<T> targetClass) throws MessagingException {
        Message<?> message = this.doReceive(destination);
        if (message != null) {
            return this.doConvert(message, targetClass);
        }
        return null;
    }

    protected <T> @Nullable T doConvert(Message<?> message, Class<T> targetClass) {
        MessageConverter messageConverter = this.getMessageConverter();
        Object value = messageConverter.fromMessage(message, targetClass);
        if (value == null) {
            throw new MessageConversionException(message, "Unable to convert payload [" + String.valueOf(message.getPayload()) + "] to type [" + String.valueOf(targetClass) + "] using converter [" + String.valueOf(messageConverter) + "]");
        }
        return (T)value;
    }

    protected abstract @Nullable Message<?> doReceive(D var1);
}

