/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.MimeType;

public class DefaultContentTypeResolver
implements ContentTypeResolver {
    private MimeType defaultMimeType;

    public void setDefaultMimeType(MimeType defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public MimeType getDefaultMimeType() {
        return this.defaultMimeType;
    }

    @Override
    public MimeType resolve(MessageHeaders headers) {
        if (headers == null || headers.get("contentType") == null) {
            return this.defaultMimeType;
        }
        Object value = headers.get("contentType");
        if (value instanceof MimeType) {
            return (MimeType)value;
        }
        if (value instanceof String) {
            return MimeType.valueOf((String)((String)value));
        }
        throw new IllegalArgumentException("Unknown type for contentType header value: " + value.getClass());
    }

    public String toString() {
        return "DefaultContentTypeResolver[defaultMimeType=" + this.defaultMimeType + "]";
    }
}

