/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class SimpleDestinationResolver
extends DynamicDestinationResolver
implements CachingDestinationResolver {
    private final Map<String, Topic> topicCache = new ConcurrentHashMap<String, Topic>(4);
    private final Map<String, Queue> queueCache = new ConcurrentHashMap<String, Queue>(4);

    @Override
    protected Topic resolveTopic(Session session, String topicName) throws JMSException {
        Topic topic = this.topicCache.get(topicName);
        if (topic != null) {
            return topic;
        }
        topic = super.resolveTopic(session, topicName);
        Topic existing = this.topicCache.putIfAbsent(topicName, topic);
        return existing != null ? existing : topic;
    }

    @Override
    protected Queue resolveQueue(Session session, String queueName) throws JMSException {
        Queue queue = this.queueCache.get(queueName);
        if (queue != null) {
            return queue;
        }
        queue = super.resolveQueue(session, queueName);
        Queue existing = this.queueCache.putIfAbsent(queueName, queue);
        return existing != null ? existing : queue;
    }

    @Override
    public void removeFromCache(String destinationName) {
        this.topicCache.remove(destinationName);
        this.queueCache.remove(destinationName);
    }

    @Override
    public void clearCache() {
        this.topicCache.clear();
        this.queueCache.clear();
    }
}

