/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.support.QosSettings;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.util.Assert;

public class JmsActivationSpecConfig {
    private static final Map<String, Integer> sessionConstants = Map.of("AUTO_ACKNOWLEDGE", 1, "CLIENT_ACKNOWLEDGE", 2, "DUPS_OK_ACKNOWLEDGE", 3, "SESSION_TRANSACTED", 0);
    private @Nullable String destinationName;
    private boolean pubSubDomain = false;
    private @Nullable Boolean replyPubSubDomain;
    private @Nullable QosSettings replyQosSettings;
    private boolean subscriptionDurable = false;
    private boolean subscriptionShared = false;
    private @Nullable String subscriptionName;
    private @Nullable String clientId;
    private @Nullable String messageSelector;
    private int acknowledgeMode = 1;
    private int maxConcurrency = -1;
    private int prefetchSize = -1;
    private @Nullable MessageConverter messageConverter;

    public void setDestinationName(@Nullable String destinationName) {
        this.destinationName = destinationName;
    }

    public @Nullable String getDestinationName() {
        return this.destinationName;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setReplyPubSubDomain(boolean replyPubSubDomain) {
        this.replyPubSubDomain = replyPubSubDomain;
    }

    public boolean isReplyPubSubDomain() {
        if (this.replyPubSubDomain != null) {
            return this.replyPubSubDomain;
        }
        return this.isPubSubDomain();
    }

    public void setReplyQosSettings(@Nullable QosSettings replyQosSettings) {
        this.replyQosSettings = replyQosSettings;
    }

    public @Nullable QosSettings getReplyQosSettings() {
        return this.replyQosSettings;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
        if (subscriptionDurable) {
            this.pubSubDomain = true;
        }
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionShared(boolean subscriptionShared) {
        this.subscriptionShared = subscriptionShared;
        if (subscriptionShared) {
            this.pubSubDomain = true;
        }
    }

    public boolean isSubscriptionShared() {
        return this.subscriptionShared;
    }

    public void setSubscriptionName(@Nullable String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public @Nullable String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setDurableSubscriptionName(@Nullable String durableSubscriptionName) {
        this.subscriptionName = durableSubscriptionName;
        this.subscriptionDurable = durableSubscriptionName != null;
    }

    public @Nullable String getDurableSubscriptionName() {
        return this.subscriptionDurable ? this.subscriptionName : null;
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    public @Nullable String getClientId() {
        return this.clientId;
    }

    public void setMessageSelector(@Nullable String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public @Nullable String getMessageSelector() {
        return this.messageSelector;
    }

    public void setAcknowledgeModeName(String constantName) {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer acknowledgeMode = sessionConstants.get(constantName);
        Assert.notNull((Object)acknowledgeMode, (String)"Only acknowledge mode constants allowed");
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        Assert.isTrue((boolean)sessionConstants.containsValue(acknowledgeMode), (String)"Only values of acknowledge mode constants allowed");
        this.acknowledgeMode = acknowledgeMode;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setConcurrency(String concurrency) {
        try {
            int separatorIndex = concurrency.indexOf(45);
            if (separatorIndex != -1) {
                this.setMaxConcurrency(Integer.parseInt(concurrency, separatorIndex + 1, concurrency.length(), 10));
            } else {
                this.setMaxConcurrency(Integer.parseInt(concurrency));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid concurrency value [" + concurrency + "]: only single maximum integer (for example, \"5\") and minimum-maximum combo (for example, \"3-5\") supported. Note that JmsActivationSpecConfig will effectively ignore the minimum value and scale from zero up to the number of consumers according to the maximum value.");
        }
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public @Nullable MessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

