/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanExpressionException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.core.SpringProperties;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.MapAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StandardBeanExpressionResolver
implements BeanExpressionResolver {
    public static final String MAX_SPEL_EXPRESSION_LENGTH_PROPERTY_NAME = "spring.context.expression.maxLength";
    public static final String DEFAULT_EXPRESSION_PREFIX = "#{";
    public static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "#{";
    private String expressionSuffix = "}";
    private ExpressionParser expressionParser;
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>(256);
    private final Map<BeanExpressionContext, StandardEvaluationContext> evaluationCache = new ConcurrentHashMap<BeanExpressionContext, StandardEvaluationContext>(8);
    private final ParserContext beanExpressionParserContext = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return StandardBeanExpressionResolver.this.expressionPrefix;
        }

        public String getExpressionSuffix() {
            return StandardBeanExpressionResolver.this.expressionSuffix;
        }
    };

    public StandardBeanExpressionResolver() {
        this(null);
    }

    public StandardBeanExpressionResolver(@Nullable ClassLoader beanClassLoader) {
        SpelParserConfiguration parserConfig = new SpelParserConfiguration(null, beanClassLoader, false, false, Integer.MAX_VALUE, StandardBeanExpressionResolver.retrieveMaxExpressionLength());
        this.expressionParser = new SpelExpressionParser(parserConfig);
    }

    public void setExpressionPrefix(String expressionPrefix) {
        Assert.hasText((String)expressionPrefix, (String)"Expression prefix must not be empty");
        this.expressionPrefix = expressionPrefix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        Assert.hasText((String)expressionSuffix, (String)"Expression suffix must not be empty");
        this.expressionSuffix = expressionSuffix;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        this.expressionParser = expressionParser;
    }

    public @Nullable Object evaluate(@Nullable String value, BeanExpressionContext beanExpressionContext) throws BeansException {
        if (!StringUtils.hasLength((String)value)) {
            return value;
        }
        try {
            Expression expr = this.expressionCache.computeIfAbsent(value, expression -> this.expressionParser.parseExpression(expression, this.beanExpressionParserContext));
            EvaluationContext evalContext = (EvaluationContext)this.evaluationCache.computeIfAbsent(beanExpressionContext, bec -> {
                ConfigurableBeanFactory beanFactory = bec.getBeanFactory();
                StandardEvaluationContext sec = new StandardEvaluationContext(bec);
                sec.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
                sec.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
                sec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanFactory));
                sec.setTypeLocator((TypeLocator)new StandardTypeLocator(beanFactory.getBeanClassLoader()));
                sec.setTypeConverter((TypeConverter)new StandardTypeConverter(() -> {
                    ConversionService cs = beanFactory.getConversionService();
                    return cs != null ? cs : DefaultConversionService.getSharedInstance();
                }));
                this.customizeEvaluationContext(sec);
                return sec;
            });
            return expr.getValue(evalContext);
        }
        catch (Throwable ex) {
            throw new BeanExpressionException("Expression parsing failed", ex);
        }
    }

    protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
    }

    private static int retrieveMaxExpressionLength() {
        String value = SpringProperties.getProperty((String)MAX_SPEL_EXPRESSION_LENGTH_PROPERTY_NAME);
        if (!StringUtils.hasText((String)value)) {
            return 10000;
        }
        try {
            int maxLength = Integer.parseInt(value.trim());
            Assert.isTrue((maxLength > 0 ? 1 : 0) != 0, () -> "Value [" + maxLength + "] for system property [spring.context.expression.maxLength] must be positive");
            return maxLength;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Failed to parse value for system property [spring.context.expression.maxLength]: " + ex.getMessage(), ex);
        }
    }
}

