/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestHandlerLoggerHolder;
import org.springframework.security.web.csrf.CsrfTokenRequestResolver;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CsrfTokenRequestHandler
extends CsrfTokenRequestResolver {
    public void handle(HttpServletRequest var1, HttpServletResponse var2, Supplier<CsrfToken> var3);

    @Override
    default public @Nullable String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)csrfToken, (String)"csrfToken cannot be null");
        String actualToken = request.getHeader(csrfToken.getHeaderName());
        if (actualToken != null) {
            return actualToken;
        }
        CsrfTokenRequestHandlerLoggerHolder.logger.trace((Object)LogMessage.format((String)"Did not find a CSRF token in the [%s] request header", (Object)csrfToken.getHeaderName()));
        actualToken = request.getParameter(csrfToken.getParameterName());
        if (actualToken != null) {
            return actualToken;
        }
        CsrfTokenRequestHandlerLoggerHolder.logger.trace((Object)LogMessage.format((String)"Did not find a CSRF token in the [%s] request parameter", (Object)csrfToken.getParameterName()));
        return null;
    }
}

