/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.rsocket.authentication;

import org.springframework.security.core.Authentication;
import org.springframework.security.rsocket.api.PayloadExchange;
import reactor.core.publisher.Mono;

/**
 * Converts from a {@link PayloadExchange} to an {@link Authentication}
 * @author Rob Winch
 * @since 5.2
 */
public interface PayloadExchangeAuthenticationConverter {
	Mono<Authentication> convert(PayloadExchange exchange);
}
