/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class ClientRegistrations {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> typeReference;

    private ClientRegistrations() {
    }

    public static ClientRegistration.Builder fromOidcConfiguration(Map<String, Object> configuration) {
        OIDCProviderMetadata metadata = ClientRegistrations.parse(configuration, OIDCProviderMetadata::parse);
        ClientRegistration.Builder builder = ClientRegistrations.withProviderConfiguration((AuthorizationServerMetadata)metadata, metadata.getIssuer().getValue());
        builder.jwkSetUri(metadata.getJWKSetURI().toASCIIString());
        if (metadata.getUserInfoEndpointURI() != null) {
            builder.userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString());
        }
        return builder;
    }

    public static ClientRegistration.Builder fromOidcIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        return ClientRegistrations.getBuilder(issuer, ClientRegistrations.oidc(issuer));
    }

    public static ClientRegistration.Builder fromIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        return ClientRegistrations.getBuilder(issuer, ClientRegistrations.oidc(issuer), ClientRegistrations.oidcRfc8414(issuer), ClientRegistrations.oauth(issuer));
    }

    static Supplier<ClientRegistration.Builder> oidc(String issuer) {
        UriComponents uri = ClientRegistrations.oidcUri(issuer);
        return () -> {
            RequestEntity request = RequestEntity.get((String)uri.toUriString(), (Object[])new Object[0]).build();
            Map configuration = (Map)rest.exchange(request, typeReference).getBody();
            OIDCProviderMetadata metadata = ClientRegistrations.parse(configuration, OIDCProviderMetadata::parse);
            ClientRegistration.Builder builder = ClientRegistrations.withProviderConfiguration((AuthorizationServerMetadata)metadata, issuer).jwkSetUri(metadata.getJWKSetURI().toASCIIString());
            if (metadata.getUserInfoEndpointURI() != null) {
                builder.userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString());
            }
            return builder;
        };
    }

    static UriComponents oidcUri(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(uri.getPath() + OIDC_METADATA_PATH).build();
    }

    static Supplier<ClientRegistration.Builder> oidcRfc8414(String issuer) {
        UriComponents uri = ClientRegistrations.oidcRfc8414Uri(issuer);
        return ClientRegistrations.getRfc8414Builder(issuer, uri);
    }

    static UriComponents oidcRfc8414Uri(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(OIDC_METADATA_PATH + uri.getPath()).build();
    }

    static Supplier<ClientRegistration.Builder> oauth(String issuer) {
        UriComponents uri = ClientRegistrations.oauthUri(issuer);
        return ClientRegistrations.getRfc8414Builder(issuer, uri);
    }

    static UriComponents oauthUri(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(OAUTH_METADATA_PATH + uri.getPath()).build();
    }

    private static Supplier<ClientRegistration.Builder> getRfc8414Builder(String issuer, UriComponents uri) {
        return () -> {
            String userinfoEndpoint;
            RequestEntity request = RequestEntity.get((String)uri.toUriString(), (Object[])new Object[0]).build();
            Map configuration = (Map)rest.exchange(request, typeReference).getBody();
            AuthorizationServerMetadata metadata = ClientRegistrations.parse(configuration, AuthorizationServerMetadata::parse);
            ClientRegistration.Builder builder = ClientRegistrations.withProviderConfiguration(metadata, issuer);
            URI jwkSetUri = metadata.getJWKSetURI();
            if (jwkSetUri != null) {
                builder.jwkSetUri(jwkSetUri.toASCIIString());
            }
            if ((userinfoEndpoint = (String)configuration.get("userinfo_endpoint")) != null) {
                builder.userInfoUri(userinfoEndpoint);
            }
            return builder;
        };
    }

    @SafeVarargs
    private static ClientRegistration.Builder getBuilder(String issuer, Supplier<ClientRegistration.Builder> ... suppliers) {
        String errorMessage = "Unable to resolve Configuration with the provided Issuer of \"" + issuer + "\"";
        ArrayList<String> errors = new ArrayList<String>();
        for (Supplier<ClientRegistration.Builder> supplier : suppliers) {
            try {
                return supplier.get();
            }
            catch (HttpClientErrorException ex) {
                if (!ex.getStatusCode().is4xxClientError()) {
                    throw ex;
                }
                errors.add(ex.getMessage());
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errorMessage + ", errors: " + String.valueOf(errors));
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static <T> T parse(Map<String, Object> body, ThrowingFunction<JSONObject, T, ParseException> parser) {
        try {
            return parser.apply(new JSONObject(body));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static ClientRegistration.Builder withProviderConfiguration(AuthorizationServerMetadata metadata, String issuer) {
        String metadataIssuer = metadata.getIssuer().getValue();
        Assert.state((boolean)issuer.equals(metadataIssuer), () -> "The Issuer \"" + metadataIssuer + "\" provided in the configuration metadata did not match the requested issuer \"" + issuer + "\"");
        String name = URI.create(issuer).getHost();
        ClientAuthenticationMethod method = ClientRegistrations.getClientAuthenticationMethod(metadata.getTokenEndpointAuthMethods());
        LinkedHashMap<String, Object> configurationMetadata = new LinkedHashMap<String, Object>((Map<String, Object>)metadata.toJSONObject());
        return ClientRegistration.withRegistrationId(name).userNameAttributeName("sub").authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(method).redirectUri("{baseUrl}/{action}/oauth2/code/{registrationId}").authorizationUri(metadata.getAuthorizationEndpointURI() != null ? metadata.getAuthorizationEndpointURI().toASCIIString() : null).providerConfigurationMetadata(configurationMetadata).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).issuerUri(issuer).clientName(issuer);
    }

    private static ClientAuthenticationMethod getClientAuthenticationMethod(List<com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod> metadataAuthMethods) {
        if (metadataAuthMethods == null || metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            return ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            return ClientAuthenticationMethod.CLIENT_SECRET_POST;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.NONE)) {
            return ClientAuthenticationMethod.NONE;
        }
        return null;
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(30000);
        requestFactory.setReadTimeout(30000);
        rest.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        typeReference = new ParameterizedTypeReference<Map<String, Object>>(){};
    }

    private static interface ThrowingFunction<S, T, E extends Throwable> {
        public T apply(S var1) throws E;
    }
}

