/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultOAuth2TokenRequestHeadersConverter;
import org.springframework.security.oauth2.client.endpoint.DefaultOAuth2TokenRequestParametersConverter;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public abstract class AbstractWebClientReactiveOAuth2AccessTokenResponseClient<T extends AbstractOAuth2AuthorizationGrantRequest>
implements ReactiveOAuth2AccessTokenResponseClient<T> {
    private WebClient webClient = WebClient.builder().build();
    private Converter<T, WebClient.RequestHeadersSpec<?>> requestEntityConverter = this::validatingPopulateRequest;
    private Converter<T, HttpHeaders> headersConverter = new DefaultOAuth2TokenRequestHeadersConverter();
    private Converter<T, MultiValueMap<String, String>> parametersConverter = new DefaultOAuth2TokenRequestParametersConverter();
    private Consumer<MultiValueMap<String, String>> parametersCustomizer = parameters -> {};
    private BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> bodyExtractor = OAuth2BodyExtractors.oauth2AccessTokenResponse();

    AbstractWebClientReactiveOAuth2AccessTokenResponseClient() {
    }

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(T grantRequest) {
        Assert.notNull(grantRequest, (String)"grantRequest cannot be null");
        return Mono.defer(() -> ((WebClient.RequestHeadersSpec)this.requestEntityConverter.convert((Object)grantRequest)).exchange().flatMap(response -> (Mono)response.body(this.bodyExtractor)));
    }

    private WebClient.RequestHeadersSpec<?> validatingPopulateRequest(T grantRequest) {
        this.validateClientAuthenticationMethod(grantRequest);
        return this.populateRequest(grantRequest);
    }

    private void validateClientAuthenticationMethod(T grantRequest) {
        boolean supportedClientAuthenticationMethod;
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration();
        ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
        boolean bl = supportedClientAuthenticationMethod = clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.NONE) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        if (!supportedClientAuthenticationMethod) {
            throw new IllegalArgumentException(String.format("This class supports `client_secret_basic`, `client_secret_post`, and `none` by default. Client [%s] is using [%s] instead. Please use a supported client authentication method, or use `set/addParametersConverter` or `set/addHeadersConverter` to supply an instance that supports [%s].", clientRegistration.getRegistrationId(), clientAuthenticationMethod, clientAuthenticationMethod));
        }
    }

    private WebClient.RequestHeadersSpec<?> populateRequest(T grantRequest) {
        MultiValueMap parameters = (MultiValueMap)this.parametersConverter.convert(grantRequest);
        if (parameters == null) {
            parameters = new LinkedMultiValueMap();
        }
        this.parametersCustomizer.accept((MultiValueMap<String, String>)parameters);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration().getProviderDetails().getTokenUri(), new Object[0])).headers(headers -> {
            HttpHeaders headersToAdd = (HttpHeaders)this.headersConverter.convert((Object)grantRequest);
            if (headersToAdd != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
        })).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)parameters));
    }

    public final void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }

    public final void setHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        this.headersConverter = headersConverter;
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        Converter currentHeadersConverter = this.headersConverter;
        this.headersConverter = authorizationGrantRequest -> {
            HttpHeaders headersToAdd;
            HttpHeaders headers = (HttpHeaders)currentHeadersConverter.convert(authorizationGrantRequest);
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if ((headersToAdd = (HttpHeaders)headersConverter.convert(authorizationGrantRequest)) != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
            return headers;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    public final void setParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        if (parametersConverter instanceof DefaultOAuth2TokenRequestParametersConverter) {
            this.parametersConverter = parametersConverter;
        } else {
            DefaultOAuth2TokenRequestParametersConverter defaultParametersConverter = new DefaultOAuth2TokenRequestParametersConverter();
            this.parametersConverter = authorizationGrantRequest -> {
                MultiValueMap parameters = (MultiValueMap)defaultParametersConverter.convert(authorizationGrantRequest);
                MultiValueMap parametersToSet = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest);
                if (parametersToSet != null) {
                    parameters.putAll((Map)parametersToSet);
                }
                return parameters;
            };
        }
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        Converter currentParametersConverter = this.parametersConverter;
        this.parametersConverter = authorizationGrantRequest -> {
            MultiValueMap parametersToAdd;
            MultiValueMap parameters = (MultiValueMap)currentParametersConverter.convert(authorizationGrantRequest);
            if (parameters == null) {
                parameters = new LinkedMultiValueMap();
            }
            if ((parametersToAdd = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest)) != null) {
                parameters.addAll(parametersToAdd);
            }
            return parameters;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    public void setParametersCustomizer(Consumer<MultiValueMap<String, String>> parametersCustomizer) {
        Assert.notNull(parametersCustomizer, (String)"parametersCustomizer cannot be null");
        this.parametersCustomizer = parametersCustomizer;
    }

    public final void setBodyExtractor(BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> bodyExtractor) {
        Assert.notNull(bodyExtractor, (String)"bodyExtractor cannot be null");
        this.bodyExtractor = bodyExtractor;
    }
}

