/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.util.Assert;

public class CompositeBatchInterceptor<K, V>
implements BatchInterceptor<K, V> {
    private final Collection<BatchInterceptor<K, V>> delegates = new ArrayList<BatchInterceptor<K, V>>();

    @SafeVarargs
    public CompositeBatchInterceptor(BatchInterceptor<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot have null entries");
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public @Nullable ConsumerRecords<K, V> intercept(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        BatchInterceptor<K, V> delegate;
        ConsumerRecords<K, V> recordsToIntercept = records;
        Iterator<BatchInterceptor<K, V>> iterator = this.delegates.iterator();
        while (iterator.hasNext() && (recordsToIntercept = (delegate = iterator.next()).intercept(recordsToIntercept, consumer)) != null) {
        }
        return recordsToIntercept;
    }

    @Override
    public void success(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        this.delegates.forEach(del -> del.success(records, consumer));
    }

    @Override
    public void failure(ConsumerRecords<K, V> records, Exception exception, Consumer<K, V> consumer) {
        this.delegates.forEach(del -> del.failure(records, exception, consumer));
    }

    @Override
    public void setupThreadState(Consumer<?, ?> consumer) {
        this.delegates.forEach(del -> del.setupThreadState(consumer));
    }

    @Override
    public void clearThreadState(Consumer<?, ?> consumer) {
        this.delegates.forEach(del -> del.clearThreadState(consumer));
    }

    public void addBatchInterceptor(BatchInterceptor<K, V> batchInterceptor) {
        this.delegates.add(batchInterceptor);
    }
}

