/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.mapping;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.type.TypeFactory;

public class DefaultJacksonJavaTypeMapper
implements JacksonJavaTypeMapper,
BeanClassLoaderAware {
    private static final List<String> TRUSTED_PACKAGES = List.of("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private volatile JacksonJavaTypeMapper.TypePrecedence typePrecedence = JacksonJavaTypeMapper.TypePrecedence.INFERRED;
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    public static final String KEY_DEFAULT_CLASSID_FIELD_NAME = "__Key_TypeId__";
    public static final String KEY_DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__Key_ContentTypeId__";
    public static final String KEY_DEFAULT_KEY_CLASSID_FIELD_NAME = "__Key_KeyTypeId__";
    private final Map<String, Class<?>> idClassMapping = new ConcurrentHashMap();
    private final Map<Class<?>, byte[]> classIdMapping = new ConcurrentHashMap();
    private String classIdFieldName = "__TypeId__";
    private String contentClassIdFieldName = "__ContentTypeId__";
    private String keyClassIdFieldName = "__KeyTypeId__";
    private @Nullable ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private TypeFactory typeFactory = TypeFactory.createDefaultInstance();

    public String getClassIdFieldName() {
        return this.classIdFieldName;
    }

    public void setClassIdFieldName(String classIdFieldName) {
        this.classIdFieldName = classIdFieldName;
    }

    public String getContentClassIdFieldName() {
        return this.contentClassIdFieldName;
    }

    public void setContentClassIdFieldName(String contentClassIdFieldName) {
        this.contentClassIdFieldName = contentClassIdFieldName;
    }

    public String getKeyClassIdFieldName() {
        return this.keyClassIdFieldName;
    }

    public void setKeyClassIdFieldName(String keyClassIdFieldName) {
        this.keyClassIdFieldName = keyClassIdFieldName;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping.putAll(idClassMapping);
        this.createReverseMap();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.typeFactory = this.typeFactory.withClassLoader(classLoader);
    }

    protected @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void addHeader(Headers headers, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            headers.add((Header)new RecordHeader(headerName, this.classIdMapping.get(clazz)));
        } else {
            headers.add((Header)new RecordHeader(headerName, clazz.getName().getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected String retrieveHeader(Headers headers, String headerName) {
        String classId = this.retrieveHeaderAsString(headers, headerName);
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    protected @Nullable String retrieveHeaderAsString(Headers headers, String headerName) {
        Header header = headers.lastHeader(headerName);
        if (header != null) {
            String classId = null;
            if (header.value() != null) {
                classId = new String(header.value(), StandardCharsets.UTF_8);
            }
            return classId;
        }
        return null;
    }

    private void createReverseMap() {
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.classIdMapping.put(clazz, id.getBytes(StandardCharsets.UTF_8));
        }
    }

    public Map<String, Class<?>> getIdClassMapping() {
        return Collections.unmodifiableMap(this.idClassMapping);
    }

    public void setUseForKey(boolean isKey) {
        if (isKey) {
            this.setClassIdFieldName(KEY_DEFAULT_CLASSID_FIELD_NAME);
            this.setContentClassIdFieldName(KEY_DEFAULT_CONTENT_CLASSID_FIELD_NAME);
            this.setKeyClassIdFieldName(KEY_DEFAULT_KEY_CLASSID_FIELD_NAME);
        }
    }

    @Override
    public JacksonJavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    @Override
    public void setTypePrecedence(JacksonJavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    @Override
    public void addTrustedPackages(String ... packagesToTrust) {
        if (this.trustedPackages.isEmpty()) {
            return;
        }
        if (packagesToTrust != null) {
            for (String trusted : packagesToTrust) {
                if ("*".equals(trusted)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(trusted);
            }
        }
    }

    @Override
    public @Nullable JavaType toJavaType(Headers headers) {
        String typeIdHeader = this.retrieveHeaderAsString(headers, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            JavaType classType = this.getClassIdType(typeIdHeader);
            if (!classType.isContainerType() || classType.isArrayType()) {
                return classType;
            }
            JavaType contentClassType = this.getClassIdType(this.retrieveHeader(headers, this.getContentClassIdFieldName()));
            if (classType.getKeyType() == null) {
                return this.typeFactory.constructCollectionLikeType(classType.getRawClass(), contentClassType);
            }
            JavaType keyClassType = this.getClassIdType(this.retrieveHeader(headers, this.getKeyClassIdFieldName()));
            return this.typeFactory.constructMapLikeType(classType.getRawClass(), keyClassType, contentClassType);
        }
        return null;
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return this.typeFactory.constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + String.valueOf(this.trustedPackages) + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return this.typeFactory.constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", (Throwable)e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!PatternMatchUtils.simpleMatch((String)trustedPackage, (String)packageName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fromJavaType(JavaType javaType, Headers headers) {
        String classIdFieldName = this.getClassIdFieldName();
        if (headers.lastHeader(classIdFieldName) != null) {
            this.removeHeaders(headers);
        }
        this.addHeader(headers, classIdFieldName, javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(headers, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(headers, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, Headers headers) {
        this.fromJavaType(this.typeFactory.constructType(clazz), headers);
    }

    @Override
    public @Nullable Class<?> toClass(Headers headers) {
        JavaType javaType = this.toJavaType(headers);
        return javaType == null ? null : javaType.getRawClass();
    }

    @Override
    public void removeHeaders(Headers headers) {
        try {
            headers.remove(this.getClassIdFieldName());
            headers.remove(this.getContentClassIdFieldName());
            headers.remove(this.getKeyClassIdFieldName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

