/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.Type;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Bytes;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.JacksonMapperUtils;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.mapping.DefaultJacksonJavaTypeMapper;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.TypeFactory;

public class JacksonJsonMessageConverter
extends MessagingMessageConverter {
    private final JsonMapper jsonMapper;
    private JacksonJavaTypeMapper typeMapper = new DefaultJacksonJavaTypeMapper();
    private final TypeFactory typeFactory;

    public JacksonJsonMessageConverter() {
        this(JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonMessageConverter(JsonMapper jsonMapper) {
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null.");
        this.jsonMapper = jsonMapper;
        this.typeFactory = jsonMapper.getTypeFactory();
    }

    public JacksonJavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(JacksonJavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
    }

    protected JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    protected Headers initialRecordHeaders(Message<?> message) {
        RecordHeaders headers = new RecordHeaders();
        this.typeMapper.fromClass(message.getPayload().getClass(), (Headers)headers);
        return headers;
    }

    @Override
    protected @Nullable Object convertPayload(Message<?> message) {
        throw new UnsupportedOperationException("Select a subclass that creates a ProducerRecord value corresponding to the configured Kafka Serializer");
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, @Nullable Type type) {
        Object value = record.value();
        if (record.value() == null) {
            return KafkaNull.INSTANCE;
        }
        JavaType javaType = this.determineJavaType(record, type);
        if (value instanceof Bytes) {
            value = ((Bytes)value).get();
        }
        if (value instanceof String) {
            try {
                return this.jsonMapper.readValue((String)value, javaType);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to convert from JSON", record, (Throwable)e);
            }
        }
        if (value instanceof byte[]) {
            try {
                return this.jsonMapper.readValue((byte[])value, javaType);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to convert from JSON", record, (Throwable)e);
            }
        }
        throw new IllegalStateException("Only String, Bytes, or byte[] supported");
    }

    private JavaType determineJavaType(ConsumerRecord<?, ?> record, @Nullable Type type) {
        JavaType javaType;
        JavaType javaType2 = javaType = this.typeMapper.getTypePrecedence().equals((Object)JacksonJavaTypeMapper.TypePrecedence.INFERRED) && type != null ? this.typeFactory.constructType(type) : this.typeMapper.toJavaType(record.headers());
        if (javaType == null) {
            javaType = type != null ? this.typeFactory.constructType(type) : this.typeFactory.constructType(Object.class);
        }
        return javaType;
    }
}

