/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.HashMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.ConsumerAwareMessageListener;
import org.springframework.kafka.listener.DelegatingMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class ConvertingMessageListener<V>
implements DelegatingMessageListener<MessageListener>,
AcknowledgingConsumerAwareMessageListener<Object, Object> {
    private final MessageListener delegate;
    private final Class<V> desiredValueType;
    private MessageConverter messageConverter;
    private @Nullable KafkaHeaderMapper headerMapper;

    public ConvertingMessageListener(MessageListener<?, V> delegateMessageListener, Class<V> desiredValueType) {
        Assert.notNull(delegateMessageListener, (String)"'delegateMessageListener' cannot be null");
        Assert.notNull(desiredValueType, (String)"'desiredValueType' cannot be null");
        this.delegate = delegateMessageListener;
        this.desiredValueType = desiredValueType;
        this.messageConverter = new GenericMessageConverter();
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' cannot be null");
        this.messageConverter = messageConverter;
    }

    public void setKafkaHeaderMapper(KafkaHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"'headerMapper' cannot be null");
        this.headerMapper = headerMapper;
    }

    @Override
    public MessageListener getDelegate() {
        return this.delegate;
    }

    @Override
    public void onMessage(ConsumerRecord receivedRecord, @Nullable Acknowledgment acknowledgment, @Nullable Consumer consumer) {
        ConsumerRecord convertedConsumerRecord = this.convertConsumerRecord(receivedRecord);
        if (this.delegate instanceof AcknowledgingConsumerAwareMessageListener) {
            this.delegate.onMessage(convertedConsumerRecord, acknowledgment, consumer);
        } else if (this.delegate instanceof ConsumerAwareMessageListener) {
            this.delegate.onMessage(convertedConsumerRecord, consumer);
        } else if (this.delegate instanceof AcknowledgingMessageListener) {
            this.delegate.onMessage(convertedConsumerRecord, acknowledgment);
        } else {
            this.delegate.onMessage(convertedConsumerRecord);
        }
    }

    private ConsumerRecord convertConsumerRecord(ConsumerRecord receivedRecord) {
        GenericMessage message;
        Object convertedPayload;
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        if (this.headerMapper != null) {
            this.headerMapper.toHeaders(receivedRecord.headers(), headerMap);
        }
        if ((convertedPayload = this.messageConverter.fromMessage((Message)(message = new GenericMessage(receivedRecord.value(), headerMap)), this.desiredValueType)) == null) {
            throw new MessageConversionException((Message)message, "Message cannot be converted by used MessageConverter");
        }
        return ConvertingMessageListener.rebuildConsumerRecord(receivedRecord, convertedPayload);
    }

    private static ConsumerRecord rebuildConsumerRecord(ConsumerRecord receivedRecord, Object convertedPayload) {
        return new ConsumerRecord(receivedRecord.topic(), receivedRecord.partition(), receivedRecord.offset(), receivedRecord.timestamp(), receivedRecord.timestampType(), receivedRecord.serializedKeySize(), receivedRecord.serializedValueSize(), receivedRecord.key(), convertedPayload, receivedRecord.headers(), receivedRecord.leaderEpoch());
    }
}

