/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Instant;
import org.springframework.kafka.KafkaException;

public class TimestampedException
extends KafkaException {
    private static final long serialVersionUID = -2544217643924234282L;
    private final long timestamp;

    public TimestampedException(Exception ex) {
        this(ex, Instant.now());
    }

    public TimestampedException(Exception ex, long timestamp) {
        super("Exception thrown at " + String.valueOf(Instant.ofEpochMilli(timestamp)), ex);
        this.timestamp = timestamp;
    }

    public TimestampedException(Exception ex, Instant now) {
        super("Exception thrown at " + String.valueOf(now), ex);
        this.timestamp = now.toEpochMilli();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

