/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.aot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class KafkaAvroBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final String CONSUMER_RECORD_CLASS_NAME = ConsumerRecord.class.getName();
    private static final String CONSUMER_RECORDS_CLASS_NAME = ConsumerRecord.class.getName();
    private static final String AVRO_GENERATED_CLASS_NAME = "org.apache.avro.specific.AvroGenerated";
    private static final boolean AVRO_PRESENT = ClassUtils.isPresent((String)"org.apache.avro.specific.AvroGenerated", null);

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (!AVRO_PRESENT) {
            return null;
        }
        Class beanType = registeredBean.getBeanClass();
        if (!KafkaAvroBeanRegistrationAotProcessor.isListener(beanType)) {
            return null;
        }
        HashSet avroTypes = new HashSet();
        if (GenericMessageListener.class.isAssignableFrom(beanType)) {
            ReflectionUtils.doWithMethods((Class)beanType, method -> {
                Type[] types = method.getGenericParameterTypes();
                if (types.length > 0) {
                    ResolvableType resolvableType = ResolvableType.forType((Type)types[0]);
                    if (List.class.equals((Object)resolvableType.getRawClass())) {
                        resolvableType = resolvableType.getGeneric(new int[]{0});
                    }
                    Class keyType = resolvableType.resolveGeneric(new int[]{0});
                    Class valueType = resolvableType.resolveGeneric(new int[]{1});
                    KafkaAvroBeanRegistrationAotProcessor.checkType(keyType, avroTypes);
                    KafkaAvroBeanRegistrationAotProcessor.checkType(valueType, avroTypes);
                }
            }, method -> method.getName().equals("onMessage"));
        }
        if (avroTypes.size() > 0) {
            return (generationContext, beanRegistrationCode) -> {
                ReflectionHints reflectionHints = generationContext.getRuntimeHints().reflection();
                avroTypes.forEach(type -> reflectionHints.registerType(type, builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS})));
            };
        }
        return null;
    }

    private static boolean isListener(Class<?> beanType) {
        return GenericMessageListener.class.isAssignableFrom(beanType);
    }

    private static void checkType(@Nullable Type paramType, Set<Class<?>> avroTypes) {
        if (paramType == null) {
            return;
        }
        boolean container = KafkaAvroBeanRegistrationAotProcessor.isContainer(paramType);
        if (!container && paramType instanceof Class) {
            MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)((Class)paramType));
            if (mergedAnnotations.isPresent(AVRO_GENERATED_CLASS_NAME)) {
                avroTypes.add((Class)paramType);
            }
        } else if (container && paramType instanceof ParameterizedType) {
            Type[] generics = ((ParameterizedType)paramType).getActualTypeArguments();
            if (generics.length > 0) {
                KafkaAvroBeanRegistrationAotProcessor.checkAvro(generics[0], avroTypes);
            }
            if (generics.length == 2) {
                KafkaAvroBeanRegistrationAotProcessor.checkAvro(generics[1], avroTypes);
            }
        }
    }

    private static void checkAvro(@Nullable Type generic, Set<Class<?>> avroTypes) {
        MergedAnnotations methodAnnotations;
        if (generic instanceof Class && (methodAnnotations = MergedAnnotations.from((AnnotatedElement)((Class)generic))).isPresent(AVRO_GENERATED_CLASS_NAME)) {
            avroTypes.add((Class)generic);
        }
    }

    private static boolean isContainer(Type paramType) {
        if (paramType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)paramType).getRawType();
            return rawType.equals(List.class) || rawType.getTypeName().equals(CONSUMER_RECORD_CLASS_NAME) || rawType.getTypeName().equals(CONSUMER_RECORDS_CLASS_NAME);
        }
        return false;
    }
}

