/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.config.MultiMethodKafkaListenerEndpoint;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;

public class KafkaListenerEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    private final List<KafkaListenerEndpointDescriptor> endpointDescriptors = new ArrayList<KafkaListenerEndpointDescriptor>();
    private List<HandlerMethodArgumentResolver> customMethodArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private KafkaListenerEndpointRegistry endpointRegistry;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private KafkaListenerContainerFactory<?> containerFactory;
    private String containerFactoryBeanName;
    private BeanFactory beanFactory;
    private boolean startImmediately;
    private Validator validator;

    public void setEndpointRegistry(KafkaListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public KafkaListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public List<HandlerMethodArgumentResolver> getCustomMethodArgumentResolvers() {
        return Collections.unmodifiableList(this.customMethodArgumentResolvers);
    }

    public void setCustomMethodArgumentResolvers(HandlerMethodArgumentResolver ... methodArgumentResolvers) {
        this.customMethodArgumentResolvers = Arrays.asList(methodArgumentResolvers);
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory kafkaHandlerMethodFactory) {
        Assert.isNull((Object)this.validator, (String)"A validator cannot be provided with a custom message handler factory");
        this.messageHandlerMethodFactory = kafkaHandlerMethodFactory;
    }

    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setContainerFactory(KafkaListenerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Nullable
    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        Assert.isNull((Object)this.messageHandlerMethodFactory, (String)"A validator cannot be provided with a custom message handler factory");
        this.validator = validator;
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        List<KafkaListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            for (KafkaListenerEndpointDescriptor descriptor : this.endpointDescriptors) {
                if (descriptor.endpoint instanceof MultiMethodKafkaListenerEndpoint && this.validator != null) {
                    ((MultiMethodKafkaListenerEndpoint)descriptor.endpoint).setValidator(this.validator);
                }
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor));
            }
            this.startImmediately = true;
        }
    }

    private KafkaListenerContainerFactory<?> resolveContainerFactory(KafkaListenerEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (KafkaListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, KafkaListenerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + KafkaListenerContainerFactory.class.getSimpleName() + " to use for [" + descriptor.endpoint + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(KafkaListenerEndpoint endpoint, KafkaListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must be set");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        KafkaListenerEndpointDescriptor descriptor = new KafkaListenerEndpointDescriptor(endpoint, factory);
        List<KafkaListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            if (this.startImmediately) {
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
    }

    public void registerEndpoint(KafkaListenerEndpoint endpoint) {
        this.registerEndpoint(endpoint, null);
    }

    private static final class KafkaListenerEndpointDescriptor {
        private final KafkaListenerEndpoint endpoint;
        private final KafkaListenerContainerFactory<?> containerFactory;

        private KafkaListenerEndpointDescriptor(KafkaListenerEndpoint endpoint, KafkaListenerContainerFactory<?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

