/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMapping {
    private String name = "";
    private String @Nullable [] pathPatterns;
    private HttpMethod[] methods = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
    private String[] params = new String[0];
    private String[] headers = new String[0];
    private String[] consumes = new String[0];
    private String[] produces = new String[0];

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPathPatterns(String ... pathPatterns) {
        Assert.notEmpty((Object[])pathPatterns, (String)"at least one path pattern is required");
        this.pathPatterns = Arrays.copyOf(pathPatterns, pathPatterns.length);
    }

    public String @Nullable [] getPathPatterns() {
        return this.pathPatterns;
    }

    public void setMethodNames(String ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported methods is required");
        this.setMethods((HttpMethod[])Arrays.stream(supportedMethods).map(HttpMethod::valueOf).toArray(HttpMethod[]::new));
    }

    public void setMethods(HttpMethod ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported methods is required");
        this.methods = Arrays.copyOf(supportedMethods, supportedMethods.length);
    }

    public HttpMethod[] getMethods() {
        return this.methods;
    }

    public void setParams(String ... params) {
        Assert.notEmpty((Object[])params, (String)"at least one param is required");
        this.params = Arrays.copyOf(params, params.length);
    }

    public String[] getParams() {
        return this.params;
    }

    public void setHeaders(String ... headers) {
        Assert.notEmpty((Object[])headers, (String)"at least one header is required");
        this.headers = Arrays.copyOf(headers, headers.length);
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setConsumes(String ... consumes) {
        Assert.notEmpty((Object[])consumes, (String)"at least one consume value is required");
        this.consumes = Arrays.copyOf(consumes, consumes.length);
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public void setProduces(String ... produces) {
        Assert.notEmpty((Object[])produces, (String)"at least one produce value is required");
        this.produces = Arrays.copyOf(produces, produces.length);
    }

    public String[] getProduces() {
        return this.produces;
    }

    public RequestMethod[] getRequestMethods() {
        RequestMethod[] requestMethods = new RequestMethod[this.methods.length];
        for (int i = 0; i < this.methods.length; ++i) {
            requestMethods[i] = RequestMethod.valueOf((String)this.methods[i].name());
        }
        return requestMethods;
    }
}

