/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.file.filters.AbstractDirectoryAwareFileListFilter;
import org.springframework.util.Assert;

public abstract class AbstractRegexPatternFileListFilter<F>
extends AbstractDirectoryAwareFileListFilter<F>
implements InitializingBean {
    private volatile Pattern pattern;

    public AbstractRegexPatternFileListFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public AbstractRegexPatternFileListFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.pattern, (String)"'pattern' must not be null!");
    }

    @Override
    public boolean accept(F file) {
        return this.alwaysAccept(file) || file != null && this.pattern.matcher(this.getFilename(file)).matches();
    }

    protected abstract String getFilename(F var1);
}

