/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.UserRecord;
import com.amazonaws.services.kinesis.producer.UserRecordFailedException;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.outbound.ConvertingFromMessageConverter;
import org.springframework.integration.aws.support.KplBackpressureException;
import org.springframework.integration.aws.support.UserRecordResponse;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;

public class KplMessageHandler
extends AbstractAwsMessageHandler<Void>
implements Lifecycle {
    private final KinesisProducer kinesisProducer;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression sequenceNumberExpression;
    private Expression glueSchemaExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;
    private Duration flushDuration = Duration.ofMillis(0L);
    private volatile boolean running;
    private volatile ScheduledFuture<?> flushFuture;
    private long backPressureThreshold = 0L;

    public KplMessageHandler(KinesisProducer kinesisProducer) {
        Assert.notNull((Object)kinesisProducer, (String)"'kinesisProducer' must not be null.");
        this.kinesisProducer = kinesisProducer;
    }

    @Deprecated
    public void setConverter(Converter<Object, byte[]> converter) {
        this.setMessageConverter(new ConvertingFromMessageConverter(converter));
    }

    public void setBackPressureThreshold(long backPressureThreshold) {
        Assert.isTrue((backPressureThreshold >= 0L ? 1 : 0) != 0, (String)"'backPressureThreshold must be greater than or equal to 0.");
        this.backPressureThreshold = backPressureThreshold;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setSequenceNumberExpressionString(String sequenceNumberExpression) {
        this.setSequenceNumberExpression(EXPRESSION_PARSER.parseExpression(sequenceNumberExpression));
    }

    public void setSequenceNumberExpression(Expression sequenceNumberExpression) {
        this.sequenceNumberExpression = sequenceNumberExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    public void setFlushDuration(Duration flushDuration) {
        Assert.notNull((Object)flushDuration, (String)"'flushDuration' must not be null.");
        this.flushDuration = flushDuration;
    }

    @Override
    public void setHeaderMapper(HeaderMapper<Void> headerMapper) {
        throw new UnsupportedOperationException("Kinesis doesn't support headers.\nConsider to use 'OutboundMessageMapper<byte[]>' for embedding headers into the record data.");
    }

    public void setGlueSchema(Schema glueSchema) {
        this.setPartitionKeyExpression((Expression)new ValueExpression((Object)glueSchema));
    }

    public void setGlueSchemaExpressionString(String glueSchemaExpression) {
        this.setGlueSchemaExpression(EXPRESSION_PARSER.parseExpression(glueSchemaExpression));
    }

    public void setGlueSchemaExpression(Expression glueSchemaExpression) {
        this.glueSchemaExpression = glueSchemaExpression;
    }

    public synchronized void start() {
        if (!this.running) {
            if (this.flushDuration.toMillis() > 0L) {
                this.flushFuture = this.getTaskScheduler().scheduleAtFixedRate(() -> ((KinesisProducer)this.kinesisProducer).flush(), this.flushDuration);
            }
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            if (this.flushFuture != null) {
                this.flushFuture.cancel(true);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    protected AwsRequest messageToAwsRequest(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof PutRecordsRequest) {
            return (PutRecordsRequest)payload;
        }
        if (payload instanceof PutRecordRequest) {
            return (PutRecordRequest)payload;
        }
        if (payload instanceof UserRecord) {
            return this.buildPutRecordRequest(message);
        }
        return this.buildPutRecordRequest(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<? extends AwsResponse> handleMessageToAws(Message<?> message, AwsRequest request) {
        try {
            if (request instanceof PutRecordsRequest) {
                PutRecordsRequest putRecordsRequest = (PutRecordsRequest)request;
                CompletableFuture<PutRecordsResponse> completableFuture = this.handlePutRecordsRequest(message, putRecordsRequest);
                return completableFuture;
            }
            CompletableFuture<UserRecordResponse> completableFuture = message.getPayload();
            if (completableFuture instanceof UserRecord) {
                UserRecord userRecord = (UserRecord)completableFuture;
                completableFuture = this.handleUserRecord(userRecord);
                return completableFuture;
            }
            PutRecordRequest putRecordRequest = (PutRecordRequest)request;
            UserRecord userRecord = new UserRecord();
            userRecord.setExplicitHashKey(putRecordRequest.explicitHashKey());
            userRecord.setData(putRecordRequest.data().asByteBuffer());
            userRecord.setPartitionKey(putRecordRequest.partitionKey());
            userRecord.setStreamName(putRecordRequest.streamName());
            this.setGlueSchemaIntoUserRecordIfAny(userRecord, message);
            completableFuture = this.handleUserRecord(userRecord);
            return completableFuture;
        }
        finally {
            if (this.flushDuration.toMillis() <= 0L) {
                this.kinesisProducer.flush();
            }
        }
    }

    @Override
    protected Map<String, ?> additionalOnSuccessHeaders(AwsRequest request, AwsResponse response) {
        if (response instanceof UserRecordResponse) {
            UserRecordResponse putRecordResponse = (UserRecordResponse)response;
            return Map.of("aws_shard", putRecordResponse.shardId(), "aws_sequenceNumber", putRecordResponse.sequenceNumber());
        }
        return null;
    }

    private CompletableFuture<PutRecordsResponse> handlePutRecordsRequest(Message<?> message, PutRecordsRequest putRecordsRequest) {
        AtomicInteger failedRecordsCount = new AtomicInteger();
        return Flux.fromIterable((Iterable)putRecordsRequest.records()).map(putRecordsRequestEntry -> {
            UserRecord userRecord = new UserRecord();
            userRecord.setExplicitHashKey(putRecordsRequestEntry.explicitHashKey());
            userRecord.setData(putRecordsRequestEntry.data().asByteBuffer());
            userRecord.setPartitionKey(putRecordsRequestEntry.partitionKey());
            userRecord.setStreamName(putRecordsRequest.streamName());
            this.setGlueSchemaIntoUserRecordIfAny(userRecord, message);
            return userRecord;
        }).concatMap(userRecord -> Mono.fromFuture(this.handleUserRecord((UserRecord)userRecord)).map(recordResult -> (PutRecordsResultEntry)PutRecordsResultEntry.builder().sequenceNumber(recordResult.sequenceNumber()).shardId(recordResult.shardId()).build()).onErrorResume(UserRecordFailedException.class, ex -> Mono.just((Object)ex.getResult()).map(errorRecord -> {
            PutRecordsResultEntry.Builder putRecordsResultEntry = PutRecordsResultEntry.builder().sequenceNumber(errorRecord.getSequenceNumber()).shardId(errorRecord.getShardId());
            failedRecordsCount.incrementAndGet();
            errorRecord.getAttempts().stream().reduce((left, right) -> right).ifPresent(attempt -> putRecordsResultEntry.errorMessage(attempt.getErrorMessage()).errorCode(attempt.getErrorCode()));
            return (PutRecordsResultEntry)putRecordsResultEntry.build();
        }))).collectList().map(putRecordsResultList -> (PutRecordsResponse)PutRecordsResponse.builder().records((Collection)putRecordsResultList).failedRecordCount(Integer.valueOf(failedRecordsCount.get())).build()).toFuture();
    }

    private void setGlueSchemaIntoUserRecordIfAny(UserRecord userRecord, Message<?> message) {
        if (this.glueSchemaExpression != null) {
            Schema schema = (Schema)this.glueSchemaExpression.getValue(this.getEvaluationContext(), message, Schema.class);
            userRecord.setSchema(schema);
        }
    }

    private CompletableFuture<UserRecordResponse> handleUserRecord(UserRecord userRecord) {
        int numberOfRecordsInFlight;
        if (this.backPressureThreshold > 0L && (long)(numberOfRecordsInFlight = this.kinesisProducer.getOutstandingRecordsCount()) > this.backPressureThreshold) {
            throw new KplBackpressureException("Cannot send record to Kinesis since buffer is at max capacity.", userRecord);
        }
        ListenableFuture recordResult = this.kinesisProducer.addUserRecord(userRecord);
        return KplMessageHandler.listenableFutureToCompletableFuture(recordResult).thenApply(UserRecordResponse::new);
    }

    private PutRecordRequest buildPutRecordRequest(Message<?> message) {
        String explicitHashKey;
        String partitionKey;
        String stream;
        Object payload = message.getPayload();
        ByteBuffer data = null;
        String sequenceNumber = null;
        if (payload instanceof UserRecord) {
            UserRecord userRecord = (UserRecord)payload;
            data = userRecord.getData();
            stream = userRecord.getStreamName();
            partitionKey = userRecord.getPartitionKey();
            explicitHashKey = userRecord.getExplicitHashKey();
        } else {
            byte[] bytes;
            MessageHeaders messageHeaders = message.getHeaders();
            stream = (String)messageHeaders.get((Object)"aws_stream", String.class);
            if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
                stream = (String)this.streamExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
            partitionKey = (String)messageHeaders.get((Object)"aws_partitionKey", String.class);
            if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
                partitionKey = (String)this.partitionKeyExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record.Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
            explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.getEvaluationContext(), message, String.class) : null;
            sequenceNumber = (String)messageHeaders.get((Object)"aws_sequenceNumber", String.class);
            if (!StringUtils.hasText((String)sequenceNumber) && this.sequenceNumberExpression != null) {
                sequenceNumber = (String)this.sequenceNumberExpression.getValue(this.getEvaluationContext(), message, String.class);
            }
            MutableMessage messageToEmbed = null;
            if (payload instanceof ByteBuffer) {
                data = (ByteBuffer)payload;
                if (this.embeddedHeadersMapper != null) {
                    messageToEmbed = new MutableMessage((Object)data.array(), (Map)messageHeaders);
                }
            } else {
                bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                if (this.embeddedHeadersMapper != null) {
                    messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
                } else {
                    data = ByteBuffer.wrap(bytes);
                }
            }
            if (messageToEmbed != null) {
                try {
                    bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                    Assert.notNull((Object)bytes, (String)"payload cannot be null");
                    data = ByteBuffer.wrap(bytes);
                }
                catch (Exception ex) {
                    throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
                }
            }
        }
        return (PutRecordRequest)PutRecordRequest.builder().streamName(stream).partitionKey(partitionKey).explicitHashKey(explicitHashKey).sequenceNumberForOrdering(sequenceNumber).data(SdkBytes.fromByteBuffer((ByteBuffer)data)).build();
    }

    private static <T> CompletableFuture<T> listenableFutureToCompletableFuture(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable ex) {
                completable.completeExceptionally(ex);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completable;
    }
}

