/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aws.config.xml.AwsParserUtils;
import org.springframework.integration.aws.outbound.SqsMessageHandler;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SqsOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SqsMessageHandler.class);
        String resourceIdResolver = element.getAttribute("resource-id-resolver");
        boolean hasResourceIdResolver = StringUtils.hasText((String)resourceIdResolver);
        builder.addConstructorArgReference(element.getAttribute("sqs"));
        if (hasResourceIdResolver) {
            builder.addConstructorArgReference(resourceIdResolver);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"sync");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-message-strategy");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"failure-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"async-handler");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"success-channel", (String)"outputChannel");
        AwsParserUtils.populateExpressionAttribute("queue", builder, element, parserContext);
        AwsParserUtils.populateExpressionAttribute("delay", builder, element, parserContext);
        AwsParserUtils.populateExpressionAttribute("message-group-id", builder, element, parserContext);
        AwsParserUtils.populateExpressionAttribute("message-deduplication-id", builder, element, parserContext);
        AwsParserUtils.populateExpressionAttribute("send-timeout", builder, element, parserContext);
        return builder.getBeanDefinition();
    }
}

