/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.support.SnsBodyBuilder;
import org.springframework.integration.aws.support.SnsHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class SnsMessageHandler
extends AbstractAwsMessageHandler<Map<String, MessageAttributeValue>> {
    private final AmazonSNSAsync amazonSns;
    private Expression topicArnExpression;
    private Expression subjectExpression;
    private Expression bodyExpression;
    private ResourceIdResolver resourceIdResolver;

    public SnsMessageHandler(AmazonSNSAsync amazonSns) {
        Assert.notNull((Object)amazonSns, (String)"amazonSns must not be null.");
        this.amazonSns = amazonSns;
        this.doSetHeaderMapper(new SnsHeaderMapper());
    }

    public void setTopicArn(String topicArn) {
        Assert.hasText((String)topicArn, (String)"topicArn must not be empty.");
        this.topicArnExpression = new LiteralExpression(topicArn);
    }

    public void setTopicArnExpression(Expression topicArnExpression) {
        Assert.notNull((Object)topicArnExpression, (String)"topicArnExpression must not be null.");
        this.topicArnExpression = topicArnExpression;
    }

    public void setSubject(String subject) {
        Assert.hasText((String)subject, (String)"subject must not be empty.");
        this.subjectExpression = new LiteralExpression(subject);
    }

    public void setSubjectExpression(Expression subjectExpression) {
        Assert.notNull((Object)subjectExpression, (String)"subjectExpression must not be null.");
        this.subjectExpression = subjectExpression;
    }

    public void setBodyExpression(Expression bodyExpression) {
        Assert.notNull((Object)bodyExpression, (String)"bodyExpression must not be null.");
        this.bodyExpression = bodyExpression;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    @Override
    protected void onInit() {
        super.onInit();
        TypeLocator typeLocator = this.getEvaluationContext().getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.integration.aws.support");
        }
    }

    @Override
    protected Future<?> handleMessageToAws(Message<?> message) {
        Object payload = message.getPayload();
        PublishRequest publishRequest = null;
        if (payload instanceof PublishRequest) {
            publishRequest = (PublishRequest)payload;
        } else {
            Assert.state((this.topicArnExpression != null ? 1 : 0) != 0, (String)"'topicArn' or 'topicArnExpression' must be specified.");
            publishRequest = new PublishRequest();
            String topicArn = (String)this.topicArnExpression.getValue(this.getEvaluationContext(), message, String.class);
            if (this.resourceIdResolver != null) {
                topicArn = this.resourceIdResolver.resolveToPhysicalResourceId(topicArn);
            }
            publishRequest.setTopicArn(topicArn);
            if (this.subjectExpression != null) {
                String subject = (String)this.subjectExpression.getValue(this.getEvaluationContext(), message, String.class);
                publishRequest.setSubject(subject);
            }
            Object snsMessage = message.getPayload();
            if (this.bodyExpression != null) {
                snsMessage = this.bodyExpression.getValue(this.getEvaluationContext(), message);
            }
            if (snsMessage instanceof SnsBodyBuilder) {
                publishRequest.withMessageStructure("json").setMessage(((SnsBodyBuilder)snsMessage).build());
            } else {
                publishRequest.setMessage((String)this.getConversionService().convert(snsMessage, String.class));
            }
            HeaderMapper headerMapper = this.getHeaderMapper();
            if (headerMapper != null) {
                this.mapHeaders(message, publishRequest, headerMapper);
            }
        }
        AsyncHandler asyncHandler = this.obtainAsyncHandler(message, (AmazonWebServiceRequest)publishRequest);
        return this.amazonSns.publishAsync(publishRequest, asyncHandler);
    }

    private void mapHeaders(Message<?> message, PublishRequest publishRequest, HeaderMapper<Map<String, MessageAttributeValue>> headerMapper) {
        HashMap messageAttributes = new HashMap();
        headerMapper.fromHeaders(message.getHeaders(), messageAttributes);
        if (!messageAttributes.isEmpty()) {
            publishRequest.setMessageAttributes(messageAttributes);
        }
    }

    @Override
    protected void additionalOnSuccessHeaders(AbstractIntegrationMessageBuilder<?> messageBuilder, AmazonWebServiceRequest request, Object result) {
        if (request instanceof PublishRequest) {
            PublishRequest publishRequest = (PublishRequest)request;
            messageBuilder.setHeader("aws_topic", (Object)publishRequest.getTopicArn());
        }
        if (result instanceof PublishResult) {
            PublishResult publishResult = (PublishResult)result;
            messageBuilder.setHeader("aws_messageId", (Object)publishResult.getMessageId());
        }
    }
}

