/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.lock;

import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class DynamoDbLockRegistry
implements ExpirableLockRegistry,
InitializingBean,
DisposableBean {
    public static final String DEFAULT_TABLE_NAME = "SpringIntegrationLockRegistry";
    public static final String DEFAULT_PARTITION_KEY_NAME = "lockKey";
    public static final String DEFAULT_SORT_KEY_NAME = "sortKey";
    public static final String DEFAULT_SORT_KEY = "SpringIntegrationLocks";
    public static final long DEFAULT_REFRESH_PERIOD_MS = 1000L;
    private static final Log logger = LogFactory.getLog(DynamoDbLockRegistry.class);
    private final ThreadFactory customizableThreadFactory = new CustomizableThreadFactory("dynamodb-lock-registry-");
    private final Map<String, DynamoDbLock> locks = new ConcurrentHashMap<String, DynamoDbLock>();
    private final CountDownLatch createTableLatch = new CountDownLatch(1);
    private final AmazonDynamoDB dynamoDB;
    private final String tableName;
    private AmazonDynamoDBLockClient dynamoDBLockClient;
    private boolean dynamoDBLockClientExplicitlySet;
    private long readCapacity = 1L;
    private long writeCapacity = 1L;
    private String partitionKey = "lockKey";
    private String sortKeyName = "sortKey";
    private String sortKey = "SpringIntegrationLocks";
    private long refreshPeriod = 1000L;
    private long leaseDuration = 20L;
    private long heartbeatPeriod = 5L;
    private boolean executorExplicitlySet;
    private volatile boolean initialized;

    public DynamoDbLockRegistry(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DEFAULT_TABLE_NAME);
    }

    public DynamoDbLockRegistry(AmazonDynamoDB dynamoDB, String tableName) {
        Assert.notNull((Object)dynamoDB, (String)"'dynamoDB' must not be null");
        Assert.hasText((String)tableName, (String)"'tableName' must not be empty");
        this.dynamoDB = dynamoDB;
        this.tableName = tableName;
    }

    public DynamoDbLockRegistry(AmazonDynamoDBLockClient dynamoDBLockClient) {
        Assert.notNull((Object)dynamoDBLockClient, (String)"'dynamoDBLockClient' must not be null");
        this.dynamoDBLockClient = dynamoDBLockClient;
        this.dynamoDBLockClientExplicitlySet = true;
        this.dynamoDB = null;
        this.tableName = null;
    }

    public void setReadCapacity(long readCapacity) {
        this.readCapacity = readCapacity;
    }

    public void setWriteCapacity(long writeCapacity) {
        this.writeCapacity = writeCapacity;
    }

    public void setPartitionKey(String partitionKey) {
        Assert.hasText((String)partitionKey, (String)"'partitionKey' must not be empty");
        this.partitionKey = partitionKey;
    }

    public void setSortKeyName(String sortKeyName) {
        this.sortKeyName = sortKeyName;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public void setLeaseDuration(long leaseDuration) {
        this.leaseDuration = leaseDuration;
    }

    public void setHeartbeatPeriod(long heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
    }

    public void setRefreshPeriod(long refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    @Deprecated
    public void setExecutor(Executor executor) {
    }

    public void afterPropertiesSet() {
        if (!this.dynamoDBLockClientExplicitlySet) {
            AmazonDynamoDBLockClientOptions dynamoDBLockClientOptions = AmazonDynamoDBLockClientOptions.builder((AmazonDynamoDB)this.dynamoDB, (String)this.tableName).withPartitionKeyName(this.partitionKey).withSortKeyName(this.sortKeyName).withHeartbeatPeriod(Long.valueOf(this.heartbeatPeriod)).withLeaseDuration(Long.valueOf(this.leaseDuration)).build();
            this.dynamoDBLockClient = new AmazonDynamoDBLockClient(dynamoDBLockClientOptions);
        }
        this.leaseDuration = (Long)new DirectFieldAccessor((Object)this.dynamoDBLockClient).getPropertyValue("leaseDurationInMilliseconds");
        this.customizableThreadFactory.newThread(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).start();
        this.initialized = true;
    }

    private void awaitForActive() {
        Assert.state((boolean)this.initialized, () -> "The component has not been initialized: " + this + ".\n Is it declared as a bean?");
        IllegalStateException illegalStateException = new IllegalStateException("The DynamoDb table " + this.tableName + " has not been created during " + 60 + " seconds");
        try {
            if (!this.createTableLatch.await(60L, TimeUnit.SECONDS)) {
                throw illegalStateException;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw illegalStateException;
        }
    }

    public void destroy() throws Exception {
        if (!this.dynamoDBLockClientExplicitlySet) {
            this.dynamoDBLockClient.close();
        }
    }

    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey, (String)"'lockKey' must of String type");
        return this.locks.computeIfAbsent((String)lockKey, x$0 -> new DynamoDbLock((String)x$0));
    }

    public void expireUnusedOlderThan(long age) {
        Iterator<Map.Entry<String, DynamoDbLock>> iterator = this.locks.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<String, DynamoDbLock> entry = iterator.next();
            DynamoDbLock lock = entry.getValue();
            if (now - lock.lastUsed <= age || lock.delegate.isHeldByCurrentThread()) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return "DynamoDbLockRegistry{tableName='" + this.tableName + '\'' + ", readCapacity=" + this.readCapacity + ", writeCapacity=" + this.writeCapacity + ", partitionKey='" + this.partitionKey + '\'' + ", sortKeyName='" + this.sortKeyName + '\'' + ", sortKey='" + this.sortKey + '\'' + ", refreshPeriod=" + this.refreshPeriod + ", leaseDuration=" + this.leaseDuration + ", heartbeatPeriod=" + this.heartbeatPeriod + '}';
    }

    private final class DynamoDbLock
    implements Lock {
        private final ReentrantLock delegate = new ReentrantLock();
        private final String key;
        private final AcquireLockOptions.AcquireLockOptionsBuilder acquireLockOptionsBuilder;
        private LockItem lockItem;
        private volatile long lastUsed = System.currentTimeMillis();

        private DynamoDbLock(String key) {
            this.key = key;
            this.acquireLockOptionsBuilder = AcquireLockOptions.builder((String)this.key).withReplaceData(Boolean.valueOf(false)).withSortKey(DynamoDbLockRegistry.this.sortKey).withTimeUnit(TimeUnit.MILLISECONDS);
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock at " + this.key, (Throwable)e);
        }

        @Override
        public void lock() {
            DynamoDbLockRegistry.this.awaitForActive();
            this.delegate.lock();
            this.setupDefaultAcquireLockOptionsBuilder();
            boolean wasInterruptedWhileUninterruptible = false;
            try {
                while (true) {
                    try {
                        while (!this.doLock()) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        wasInterruptedWhileUninterruptible = true;
                        continue;
                    }
                    catch (Exception e) {
                        this.delegate.unlock();
                        this.rethrowAsLockException(e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (wasInterruptedWhileUninterruptible) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void setupDefaultAcquireLockOptionsBuilder() {
            this.acquireLockOptionsBuilder.withAdditionalTimeToWaitForLock(Long.valueOf(Long.MAX_VALUE - DynamoDbLockRegistry.this.leaseDuration)).withRefreshPeriod(Long.valueOf(DynamoDbLockRegistry.this.refreshPeriod));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            DynamoDbLockRegistry.this.awaitForActive();
            this.delegate.lockInterruptibly();
            this.setupDefaultAcquireLockOptionsBuilder();
            try {
                while (!this.doLock()) {
                    Thread.sleep(100L);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException ie) {
                this.delegate.unlock();
                Thread.currentThread().interrupt();
                throw ie;
            }
            catch (Exception e) {
                this.delegate.unlock();
                this.rethrowAsLockException(e);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long start = System.currentTimeMillis();
            DynamoDbLockRegistry.this.awaitForActive();
            if (!this.delegate.tryLock(time, unit)) {
                return false;
            }
            long additionalTimeToWait = Math.max(TimeUnit.MILLISECONDS.convert(time, unit) - System.currentTimeMillis() + start, 0L);
            this.acquireLockOptionsBuilder.withAdditionalTimeToWaitForLock(Long.valueOf(additionalTimeToWait)).withRefreshPeriod(Long.valueOf(DynamoDbLockRegistry.this.refreshPeriod));
            boolean acquired = false;
            try {
                acquired = this.doLock();
                if (!acquired) {
                    this.delegate.unlock();
                } else {
                    this.lastUsed = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                this.delegate.unlock();
                this.rethrowAsLockException(e);
            }
            return acquired;
        }

        private boolean doLock() throws InterruptedException {
            boolean acquired;
            if (this.lockItem != null) {
                this.lockItem.sendHeartBeat();
                acquired = true;
            } else {
                this.lockItem = DynamoDbLockRegistry.this.dynamoDBLockClient.tryAcquireLock(this.acquireLockOptionsBuilder.build()).orElse(null);
                boolean bl = acquired = this.lockItem != null;
            }
            if (acquired) {
                this.lastUsed = System.currentTimeMillis();
            }
            return acquired;
        }

        @Override
        public void unlock() {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("You do not own lock at " + this.key);
            }
            if (this.delegate.getHoldCount() > 1) {
                this.delegate.unlock();
                return;
            }
            try {
                if (Thread.currentThread().isInterrupted()) {
                    LockItem lockItemToRelease = this.lockItem;
                    DynamoDbLockRegistry.this.customizableThreadFactory.newThread(() -> DynamoDbLockRegistry.this.dynamoDBLockClient.releaseLock(lockItemToRelease)).start();
                } else {
                    DynamoDbLockRegistry.this.dynamoDBLockClient.releaseLock(this.lockItem);
                }
            }
            catch (Exception e) {
                throw new DataAccessResourceFailureException("Failed to release lock at " + this.key, (Throwable)e);
            }
            finally {
                this.lockItem = null;
                this.delegate.unlock();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("DynamoDb locks don't support conditions.");
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@HH:mm:ss.SSS");
            return "DynamoDbLock [lockKey=" + this.key + ",lockedAt=" + dateFormat.format(new Date(this.lastUsed)) + ", lockItem=" + this.lockItem + "]";
        }
    }
}

