/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.graphql.support.DocumentSource;
import reactor.core.publisher.Mono;

public class CachingDocumentSource
implements DocumentSource {
    private final DocumentSource delegate;
    private boolean cacheEnabled = true;
    private final Map<String, Mono<String>> documentCache = new ConcurrentHashMap<String, Mono<String>>();

    public CachingDocumentSource(DocumentSource delegate) {
        this.delegate = delegate;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        if (!cacheEnabled) {
            this.documentCache.clear();
        }
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public Mono<String> getDocument(String name) {
        return this.isCacheEnabled() ? this.documentCache.computeIfAbsent(name, k -> this.delegate.getDocument(name).cache()) : this.delegate.getDocument(name);
    }

    public void clearCache() {
        this.documentCache.clear();
    }
}

