/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method;

import graphql.GraphQLContext;
import io.micrometer.context.ContextSnapshot;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.execution.ContextPropagationHelper;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class InvocableHandlerMethodSupport
extends HandlerMethod {
    private static final Object NO_VALUE = new Object();
    private static final boolean KOTLIN_REFLECT_PRESENT = KotlinDetector.isKotlinReflectPresent();
    private final @Nullable Executor executor;
    private final boolean hasCallableReturnValue;
    private final boolean invokeAsync;

    @Deprecated(since="1.3.0", forRemoval=true)
    protected InvocableHandlerMethodSupport(HandlerMethod handlerMethod, @Nullable Executor executor) {
        this(handlerMethod, executor, false);
    }

    protected InvocableHandlerMethodSupport(HandlerMethod handlerMethod, @Nullable Executor executor, boolean invokeAsync) {
        super(handlerMethod.createWithResolvedBean());
        this.executor = executor;
        this.hasCallableReturnValue = this.getReturnType().getParameterType().equals(Callable.class);
        this.invokeAsync = invokeAsync && !this.hasCallableReturnValue;
        Assert.isTrue((!this.hasCallableReturnValue && !invokeAsync || executor != null ? 1 : 0) != 0, (String)("Controller method has Callable return value or invokeAsync=true, but Executor not provided: " + handlerMethod.getBridgedMethod().toGenericString()));
    }

    protected @Nullable Object doInvoke(GraphQLContext graphQLContext, Object ... argValues) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Invoking " + this.getBridgedMethod().getName() + "(" + Arrays.toString(argValues) + ")"));
        }
        Method method = this.getBridgedMethod();
        try {
            CompletableFuture<?> result;
            if (KotlinDetector.isSuspendingFunction((Method)method)) {
                return InvocableHandlerMethodSupport.invokeSuspendingFunction(this.getBean(), method, argValues);
            }
            if (this.invokeAsync) {
                Callable<Object> callable = () -> method.invoke(this.getBean(), argValues);
                result = this.adaptCallable(graphQLContext, callable, method, argValues);
            } else {
                result = method.invoke(this.getBean(), argValues);
                if (this.hasCallableReturnValue && result != null) {
                    result = this.adaptCallable(graphQLContext, (Callable)((Object)result), method, argValues);
                }
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            return Mono.error((Throwable)this.processIllegalArgumentException(argValues, ex, method));
        }
        catch (InvocationTargetException ex) {
            return Mono.error((Throwable)this.processInvocationTargetException(argValues, ex));
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private static Object invokeSuspendingFunction(Object bean, Method method, @Nullable Object[] argValues) {
        Publisher result = CoroutinesUtils.invokeSuspendingFunction((Method)method, (Object)bean, (Object[])argValues);
        Assert.state((boolean)KOTLIN_REFLECT_PRESENT, (String)"Missing org.jetbrains.kotlin:kotlin-reflect dependency");
        Class<?> returnType = KotlinReflectionUtils.getReturnType(method);
        if (CompletableFuture.class.isAssignableFrom(returnType)) {
            return ((Mono)result).flatMap(Mono::fromFuture);
        }
        return result;
    }

    private CompletableFuture<?> adaptCallable(GraphQLContext graphQLContext, Callable<?> result, Method method, @Nullable Object[] argValues) {
        CompletableFuture future = new CompletableFuture();
        Assert.state((this.executor != null ? 1 : 0) != 0, (String)"No Executor configured for Callable return values");
        this.executor.execute(() -> {
            try {
                ContextSnapshot snapshot = ContextPropagationHelper.captureFrom(graphQLContext);
                Object value = snapshot.wrap(result).call();
                future.complete(value);
            }
            catch (IllegalArgumentException ex) {
                future.completeExceptionally(this.processIllegalArgumentException(argValues, ex, method));
            }
            catch (InvocationTargetException ex) {
                future.completeExceptionally(this.processInvocationTargetException(argValues, ex));
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    private IllegalStateException processIllegalArgumentException(@Nullable Object[] argValues, IllegalArgumentException ex, Method method) {
        this.assertTargetBean(method, this.getBean(), argValues);
        String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
        return new IllegalStateException(this.formatInvokeError(text, argValues), ex);
    }

    private Throwable processInvocationTargetException(@Nullable Object[] argValues, InvocationTargetException ex) {
        Throwable targetException = ex.getTargetException();
        if (targetException instanceof Error || targetException instanceof Exception) {
            return targetException;
        }
        String message = this.formatInvokeError("Invocation failure", argValues);
        return new IllegalStateException(message, targetException);
    }

    protected Mono<@Nullable Object[]> toArgsMono(@Nullable Object[] args) {
        ArrayList<Mono> monoList = new ArrayList<Mono>();
        for (Object arg : args) {
            Mono argMono = arg instanceof Mono ? (Mono)arg : Mono.justOrEmpty((Object)arg);
            monoList.add(argMono.defaultIfEmpty(NO_VALUE));
        }
        return Mono.zip(monoList, values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (values[i] != NO_VALUE) continue;
                values[i] = null;
            }
            return values;
        });
    }

    static class KotlinReflectionUtils {
        KotlinReflectionUtils() {
        }

        static Class<?> getReturnType(Method method) {
            KFunction kotlinFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
            if (kotlinFunction == null) {
                throw new IllegalArgumentException(String.format("Cannot resolve %s to a KFunction", method));
            }
            return JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)kotlinFunction.getReturnType()));
        }
    }
}

