/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ContextPropagationHelper {
    private static final ContextSnapshotFactory sharedInstance = ContextSnapshotFactory.builder().build();
    private static final String CONTEXT_SNAPSHOT_FACTORY_KEY = ContextPropagationHelper.class.getName() + ".KEY";
    private static final String CANCELED_KEY = ContextPropagationHelper.class.getName() + ".canceled";
    private static final String CANCELED_PUBLISHER_KEY = ContextPropagationHelper.class.getName() + ".canceledPublisher";

    public static ContextSnapshotFactory selectInstance(@Nullable ContextSnapshotFactory factory) {
        if (factory != null) {
            return factory;
        }
        return sharedInstance;
    }

    public static Context saveInstance(ContextSnapshotFactory factory, Context context) {
        return context.put((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, (Object)factory);
    }

    public static void saveInstance(ContextSnapshotFactory factory, GraphQLContext context) {
        context.put((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, (Object)factory);
    }

    public static ContextSnapshotFactory getInstance(ContextView contextView) {
        ContextSnapshotFactory factory = (ContextSnapshotFactory)contextView.getOrDefault((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, null);
        return ContextPropagationHelper.selectInstance(factory);
    }

    public static ContextSnapshotFactory getInstance(GraphQLContext context) {
        ContextSnapshotFactory factory = (ContextSnapshotFactory)context.get((Object)CONTEXT_SNAPSHOT_FACTORY_KEY);
        return ContextPropagationHelper.selectInstance(factory);
    }

    public static ContextSnapshot captureFrom(ContextView contextView) {
        ContextSnapshotFactory factory = ContextPropagationHelper.getInstance(contextView);
        return ContextPropagationHelper.selectInstance(factory).captureFrom(new Object[]{contextView});
    }

    public static ContextSnapshot captureFrom(GraphQLContext context) {
        ContextSnapshotFactory factory = ContextPropagationHelper.getInstance(context);
        return ContextPropagationHelper.selectInstance(factory).captureFrom(new Object[]{context});
    }

    public static Runnable createCancelSignal(GraphQLContext context) {
        AtomicBoolean requestCancelled = new AtomicBoolean();
        Sinks.Empty cancelSignal = Sinks.empty();
        context.put((Object)CANCELED_KEY, (Object)requestCancelled);
        context.put((Object)CANCELED_PUBLISHER_KEY, (Object)cancelSignal.asMono());
        return () -> {
            requestCancelled.set(true);
            cancelSignal.tryEmitEmpty();
        };
    }

    public static boolean isCancelled(GraphQLContext context) {
        AtomicBoolean requestCancelled = (AtomicBoolean)context.get((Object)CANCELED_KEY);
        if (requestCancelled != null) {
            return requestCancelled.get();
        }
        return false;
    }

    public static <T> Flux<T> bindCancelFrom(Flux<T> source, GraphQLContext context) {
        Mono cancelSignal = (Mono)context.get((Object)CANCELED_PUBLISHER_KEY);
        if (cancelSignal != null) {
            return source.takeUntilOther((Publisher)cancelSignal);
        }
        return source;
    }
}

