/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.query.SortStrategy;
import org.springframework.util.Assert;

public class SortMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SortStrategy sortStrategy;

    public SortMethodArgumentResolver(SortStrategy sortStrategy) {
        Assert.notNull((Object)sortStrategy, (String)"SortStrategy is required");
        this.sortStrategy = sortStrategy;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.nestedIfOptional().getNestedParameterType().equals(Sort.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        Sort sort = this.sortStrategy.extract(environment);
        if (parameter.isOptional()) {
            sort = sort == Sort.unsorted() ? null : sort;
            return Optional.ofNullable(sort);
        }
        return sort != null ? sort : Sort.unsorted();
    }
}

