/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import java.util.Map;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.lang.Nullable;

public class RepresentationException
extends RuntimeException {
    private final Map<String, Object> representation;
    @Nullable
    private final HandlerMethod handlerMethod;
    private final ErrorType errorType;

    public RepresentationException(Map<String, Object> representation, String msg) {
        this(representation, null, msg);
    }

    public RepresentationException(Map<String, Object> representation, @Nullable HandlerMethod hm, String msg) {
        super(msg);
        this.representation = representation;
        this.handlerMethod = hm;
        this.errorType = representation.get("__typename") == null ? ErrorType.BAD_REQUEST : ErrorType.INTERNAL_ERROR;
    }

    @Nullable
    public Map<String, Object> getRepresentation() {
        return this.representation;
    }

    @Nullable
    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }
}

