/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.mediatype.alps.Alps;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;

public class AlpsJacksonJsonHttpMessageConverter
extends JacksonJsonHttpMessageConverter
implements ResponseBodyAdvice<Object> {
    private final RootResourceInformationToAlpsDescriptorConverter converter;

    public AlpsJacksonJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter converter) {
        this(JsonMapper.builder(), converter);
    }

    public AlpsJacksonJsonHttpMessageConverter(JsonMapper objectMapper, RootResourceInformationToAlpsDescriptorConverter converter) {
        this(objectMapper.rebuild(), converter);
    }

    AlpsJacksonJsonHttpMessageConverter(JsonMapper.Builder objectMapper, RootResourceInformationToAlpsDescriptorConverter converter) {
        super(((JsonMapper.Builder)((JsonMapper.Builder)objectMapper.changeDefaultPropertyInclusion(it -> it.withValueInclusion(JsonInclude.Include.NON_EMPTY))).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).build());
        Assert.notNull((Object)converter, (String)"Converter must not be null");
        this.converter = converter;
        this.setSupportedMediaTypes(Arrays.asList(MediaTypes.ALPS_JSON, MediaType.APPLICATION_JSON, MediaType.ALL));
    }

    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return (clazz.isAssignableFrom(Alps.class) || clazz.isAssignableFrom(RootResourceInformation.class)) && super.canWrite(clazz, mediaType);
    }

    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        return false;
    }

    public @Nullable Object beforeBodyWrite(@Nullable Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        return body instanceof RootResourceInformation ? Collections.singletonMap("alps", this.converter.convert((RootResourceInformation)((Object)body))) : body;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return converterType.equals(AlpsJacksonJsonHttpMessageConverter.class);
    }
}

