/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityProjector
extends DefaultExcerptProjector
implements Projector {
    private final ProjectionDefinitions definitions;
    private final ProjectionFactory factory;
    private final String projection;

    public PersistentEntityProjector(ProjectionDefinitions projectionDefinitions, ProjectionFactory factory, String projection, ResourceMappings mappings) {
        super(factory, mappings);
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null!");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        this.factory = factory;
        this.definitions = projectionDefinitions;
        this.projection = projection;
    }

    @Override
    public Object project(Object source) {
        Assert.notNull((Object)source, (String)"Projection source must not be null!");
        if (!StringUtils.hasText((String)this.projection)) {
            return source;
        }
        Class projectionType = this.definitions.getProjectionType(source.getClass(), this.projection);
        return projectionType == null ? source : this.factory.createProjection(projectionType, source);
    }
}

