/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.halbrowser;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@BasePathAwareController
public class HalBrowser {
    private static String BROWSER = "/browser";
    public static String BROWSER_INDEX = BROWSER.concat("/index.html");
    private final RepositoryRestConfiguration configuration;

    @Autowired
    public HalBrowser(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.GET}, produces={"text/html"})
    public View index() {
        return this.browser();
    }

    @RequestMapping(value={"/browser"}, method={RequestMethod.GET})
    public View browser() {
        String basePath = this.configuration.getBasePath().toString();
        return new RedirectView(basePath.concat(BROWSER_INDEX).concat("#").concat(basePath), true);
    }
}

