/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.util.Assert;

public class Like
extends AbstractSegment
implements Condition {
    private final Expression left;
    private final Expression right;
    private final boolean negated;

    private Like(Expression left, Expression right, boolean negated) {
        super(left, right);
        this.left = left;
        this.right = right;
        this.negated = negated;
    }

    public static Like create(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        Assert.notNull((Object)leftColumnOrExpression, (String)"Left expression must not be null");
        Assert.notNull((Object)rightColumnOrExpression, (String)"Right expression must not be null");
        return new Like(leftColumnOrExpression, rightColumnOrExpression, false);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public Like not() {
        return new Like(this.left, this.right, !this.negated);
    }

    @Override
    public String toString() {
        return String.valueOf(this.left) + (this.negated ? " NOT" : "") + " LIKE " + String.valueOf(this.right);
    }
}

