/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.util.Assert;

class LettuceInvoker {
    private final RedisClusterAsyncCommands<byte[], byte[]> connection;
    private final Synchronizer synchronizer;

    LettuceInvoker(RedisClusterAsyncCommands<byte[], byte[]> connection, Synchronizer synchronizer) {
        this.connection = connection;
        this.synchronizer = synchronizer;
    }

    <R> @Nullable R just(ConnectionFunction0<@Nullable R> function) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection), Converters.identityConverter(), () -> null);
    }

    <R, T1> @Nullable R just(ConnectionFunction1<T1, @Nullable R> function, T1 t1) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection, t1));
    }

    <R, T1, T2> @Nullable R just(ConnectionFunction2<T1, T2, @Nullable R> function, T1 t1, T2 t2) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection, t1, t2));
    }

    <R, T1, T2, T3> @Nullable R just(ConnectionFunction3<T1, T2, T3, @Nullable R> function, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection, t1, t2, t3));
    }

    <R, T1, T2, T3, T4> @Nullable R just(ConnectionFunction4<T1, T2, T3, T4, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection, t1, t2, t3, t4));
    }

    <R, T1, T2, T3, T4, T5> @Nullable R just(ConnectionFunction5<T1, T2, T3, T4, T5, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return (R)this.synchronizer.invoke(() -> function.apply(this.connection, t1, t2, t3, t4, t5));
    }

    <R> SingleInvocationSpec<@Nullable R> from(ConnectionFunction0<@Nullable R> function) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return new DefaultSingleInvocationSpec(() -> function.apply(this.connection), this.synchronizer);
    }

    <R, T1> SingleInvocationSpec<@Nullable R> from(ConnectionFunction1<T1, @Nullable R> function, T1 t1) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.from(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1));
    }

    <R, T1, T2> SingleInvocationSpec<@Nullable R> from(ConnectionFunction2<T1, T2, @Nullable R> function, T1 t1, T2 t2) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.from(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2));
    }

    <R, T1, T2, T3> SingleInvocationSpec<@Nullable R> from(ConnectionFunction3<T1, T2, T3, @Nullable R> function, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.from(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3));
    }

    <R, T1, T2, T3, T4> SingleInvocationSpec<@Nullable R> from(ConnectionFunction4<T1, T2, T3, T4, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.from(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3, t4));
    }

    <R, T1, T2, T3, T4, T5> SingleInvocationSpec<@Nullable R> from(ConnectionFunction5<T1, T2, T3, T4, T5, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.from(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3, t4, t5));
    }

    <R extends Collection<E>, E> ManyInvocationSpec<E> fromMany(ConnectionFunction0<R> function) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return new DefaultManyInvocationSpec(() -> function.apply(this.connection), this.synchronizer);
    }

    <R extends Collection<E>, E, T1> ManyInvocationSpec<E> fromMany(ConnectionFunction1<T1, @Nullable R> function, T1 t1) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.fromMany(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1));
    }

    <R extends Collection<E>, E, T1, T2> ManyInvocationSpec<E> fromMany(ConnectionFunction2<T1, T2, @Nullable R> function, T1 t1, T2 t2) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.fromMany(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2));
    }

    <R extends Collection<E>, E, T1, T2, T3> ManyInvocationSpec<E> fromMany(ConnectionFunction3<T1, T2, T3, @Nullable R> function, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.fromMany(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3));
    }

    <R extends Collection<E>, E, T1, T2, T3, T4> ManyInvocationSpec<E> fromMany(ConnectionFunction4<T1, T2, T3, T4, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.fromMany(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3, t4));
    }

    <R extends Collection<E>, E, T1, T2, T3, T4, T5> ManyInvocationSpec<E> fromMany(ConnectionFunction5<T1, T2, T3, T4, T5, @Nullable R> function, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, (String)"ConnectionFunction must not be null");
        return this.fromMany(it -> function.apply((RedisClusterAsyncCommands<byte[], byte[]>)it, t1, t2, t3, t4, t5));
    }

    @FunctionalInterface
    static interface Synchronizer {
        default public <I, T> @Nullable T invoke(Supplier<RedisFuture<I>> futureSupplier) {
            return (T)this.doInvoke(futureSupplier, Converters.identityConverter(), () -> null);
        }

        default public <I, T> @Nullable T invoke(Supplier<RedisFuture<I>> futureSupplier, Converter<I, @Nullable T> converter, Supplier<@Nullable T> nullDefault) {
            return (T)this.doInvoke(futureSupplier, converter, nullDefault);
        }

        public @Nullable Object doInvoke(Supplier<RedisFuture<Object>> var1, Converter<Object, @Nullable Object> var2, Supplier<@Nullable Object> var3);
    }

    @FunctionalInterface
    static interface ConnectionFunction0<R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1);
    }

    @FunctionalInterface
    static interface ConnectionFunction1<T1, R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1, T1 var2);
    }

    @FunctionalInterface
    static interface ConnectionFunction2<T1, T2, R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1, T1 var2, T2 var3);
    }

    @FunctionalInterface
    static interface ConnectionFunction3<T1, T2, T3, R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1, T1 var2, T2 var3, T3 var4);
    }

    @FunctionalInterface
    static interface ConnectionFunction4<T1, T2, T3, T4, R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1, T1 var2, T2 var3, T3 var4, T4 var5);
    }

    @FunctionalInterface
    static interface ConnectionFunction5<T1, T2, T3, T4, T5, R> {
        public RedisFuture<R> apply(RedisClusterAsyncCommands<byte[], byte[]> var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6);
    }

    static class DefaultSingleInvocationSpec<S>
    implements SingleInvocationSpec<S> {
        private final Supplier<RedisFuture<S>> parent;
        private final Synchronizer synchronizer;

        public DefaultSingleInvocationSpec(Supplier<RedisFuture<S>> parent, Synchronizer synchronizer) {
            this.parent = parent;
            this.synchronizer = synchronizer;
        }

        @Override
        public <T> @Nullable T get(Converter<S, @Nullable T> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            return (T)this.synchronizer.invoke(this.parent, converter, () -> null);
        }

        @Override
        public <T> @Nullable T getOrElse(Converter<S, @Nullable T> converter, Supplier<@Nullable T> nullDefault) {
            Assert.notNull(converter, (String)"Converter must not be null");
            return this.synchronizer.invoke(this.parent, converter, nullDefault);
        }
    }

    static interface SingleInvocationSpec<S> {
        public <T> @Nullable T get(Converter<S, T> var1);

        default public <T> @Nullable T orElse(Converter<S, T> converter, @Nullable T nullDefault) {
            return (T)this.getOrElse(converter, () -> nullDefault);
        }

        public <T> @Nullable T getOrElse(Converter<S, T> var1, Supplier<@Nullable T> var2);
    }

    static class DefaultManyInvocationSpec<S>
    implements ManyInvocationSpec<S> {
        private final Supplier<RedisFuture<Collection<S>>> parent;
        private final Synchronizer synchronizer;

        public DefaultManyInvocationSpec(Supplier<RedisFuture<? extends Collection<S>>> parent, Synchronizer synchronizer) {
            this.parent = parent;
            this.synchronizer = synchronizer;
        }

        @Override
        public <T> List<@Nullable T> toList(Converter<S, @Nullable T> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            return this.synchronizer.invoke(this.parent, source -> {
                if (source.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<Object> result = new ArrayList<Object>(source.size());
                for (Object s : source) {
                    result.add(converter.convert(s));
                }
                return result;
            }, Collections::emptyList);
        }

        @Override
        public <T> Set<@Nullable T> toSet(Converter<S, @Nullable T> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            return this.synchronizer.invoke(this.parent, source -> {
                if (source.isEmpty()) {
                    return Collections.emptySet();
                }
                LinkedHashSet<Object> result = new LinkedHashSet<Object>(source.size());
                for (Object s : source) {
                    result.add(converter.convert(s));
                }
                return result;
            }, Collections::emptySet);
        }
    }

    static interface ManyInvocationSpec<S> {
        default public List<@Nullable S> toList() {
            return this.toList(Converters.identityConverter());
        }

        public <T> List<@Nullable T> toList(Converter<S, @Nullable T> var1);

        default public Set<@Nullable S> toSet() {
            return this.toSet(Converters.identityConverter());
        }

        public <T> Set<@Nullable T> toSet(Converter<S, @Nullable T> var1);
    }
}

