/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisSetCommands
implements RedisSetCommands {
    private final JedisConnection connection;

    JedisSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sadd(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sadd(key, values)));
                return null;
            }
            return this.connection.getJedis().sadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().scard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().scard(key)));
                return null;
            }
            return this.connection.getJedis().scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sdiff(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sdiff(keys)));
                return null;
            }
            return this.connection.getJedis().sdiff(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sdiffstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sdiffstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sdiffstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sinter(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sinter(keys)));
                return null;
            }
            return this.connection.getJedis().sinter(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sinterstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sinterstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sinterstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sismember(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sismember(key, value)));
                return null;
            }
            return this.connection.getJedis().sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().smembers(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().smembers(key)));
                return null;
            }
            return this.connection.getJedis().smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().smove(srcKey, destKey, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().spop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().spop(key)));
                return null;
            }
            return this.connection.getJedis().spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().spop(key, count), ArrayList::new));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().spop(key, count), ArrayList::new));
                return null;
            }
            return new ArrayList<byte[]>(this.connection.getJedis().spop(key, count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().srandmember(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().srandmember(key)));
                return null;
            }
            return this.connection.getJedis().srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count must be less than Integer.MAX_VALUE for sRandMember in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().srandmember(key, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().srandmember(key, (int)count)));
                return null;
            }
            return this.connection.getJedis().srandmember(key, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().srem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().srem(key, values)));
                return null;
            }
            return this.connection.getJedis().srem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sunion(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sunion(keys)));
                return null;
            }
            return this.connection.getJedis().sunion(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)keys, (String)"Source keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sunionstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sunionstore(destKey, keys)));
                return null;
            }
            return this.connection.getJedis().sunionstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisSetCommands.this.isQueueing() || JedisSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisSetCommands.this.connection.getJedis().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

