/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.Row;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

abstract class R2dbcConverters {
    private R2dbcConverters() {
    }

    public static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)RowToBooleanConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.INSTANCE);
        converters.add((Object)RowToLocalDateConverter.INSTANCE);
        converters.add((Object)RowToLocalDateTimeConverter.INSTANCE);
        converters.add((Object)RowToLocalTimeConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.RowToOffsetDateTimeConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.RowToStringConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.RowToUuidConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.RowToZonedDateTimeConverter.INSTANCE);
        return converters;
    }

    public static enum RowToBooleanConverter implements Converter<Row, Boolean>
    {
        INSTANCE;


        public Boolean convert(Row row) {
            return (Boolean)row.get(0, Boolean.class);
        }
    }

    public static enum RowToNumberConverterFactory implements ConverterFactory<Row, Number>
    {
        INSTANCE;


        public <T extends Number> Converter<Row, T> getConverter(Class<T> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            return new RowToNumber<T>(targetType);
        }

        static class RowToNumber<T extends Number>
        implements Converter<Row, T> {
            private final Class<T> targetType;

            RowToNumber(Class<T> targetType) {
                this.targetType = targetType;
            }

            public T convert(Row source) {
                Object object = source.get(0);
                return (T)(object != null ? (Number)NumberUtils.convertNumberToTargetClass((Number)((Number)object), this.targetType) : (Number)null);
            }
        }

        public static enum RowToZonedDateTimeConverter implements Converter<Row, ZonedDateTime>
        {
            INSTANCE;


            public ZonedDateTime convert(Row row) {
                return (ZonedDateTime)row.get(0, ZonedDateTime.class);
            }
        }

        public static enum RowToUuidConverter implements Converter<Row, UUID>
        {
            INSTANCE;


            public UUID convert(Row row) {
                return (UUID)row.get(0, UUID.class);
            }
        }

        public static enum RowToStringConverter implements Converter<Row, String>
        {
            INSTANCE;


            public String convert(Row row) {
                return (String)row.get(0, String.class);
            }
        }

        public static enum RowToOffsetDateTimeConverter implements Converter<Row, OffsetDateTime>
        {
            INSTANCE;


            public OffsetDateTime convert(Row row) {
                return (OffsetDateTime)row.get(0, OffsetDateTime.class);
            }
        }
    }

    public static enum RowToLocalDateConverter implements Converter<Row, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Row row) {
            return (LocalDate)row.get(0, LocalDate.class);
        }
    }

    public static enum RowToLocalDateTimeConverter implements Converter<Row, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Row row) {
            return (LocalDateTime)row.get(0, LocalDateTime.class);
        }
    }

    public static enum RowToLocalTimeConverter implements Converter<Row, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Row row) {
            return (LocalTime)row.get(0, LocalTime.class);
        }
    }
}

