/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.query.DiskUse;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Meta {
    private Map<String, Object> values = Collections.emptyMap();
    private Set<CursorOption> flags = Collections.emptySet();
    private @Nullable Integer cursorBatchSize;
    private DiskUse diskUse = DiskUse.DEFAULT;

    public Meta() {
    }

    Meta(Meta source) {
        this.values = new LinkedHashMap<String, Object>(source.values);
        this.flags = new LinkedHashSet<CursorOption>(source.flags);
        this.cursorBatchSize = source.cursorBatchSize;
        this.diskUse = source.diskUse;
    }

    public boolean hasMaxTime() {
        Long maxTimeMsec = this.getMaxTimeMsec();
        return maxTimeMsec != null && maxTimeMsec > 0L;
    }

    public @Nullable Long getMaxTimeMsec() {
        return (Long)this.getValue(MetaKey.MAX_TIME_MS.key);
    }

    public Long getRequiredMaxTimeMsec() {
        Long maxTimeMsec = this.getMaxTimeMsec();
        if (maxTimeMsec == null) {
            throw new IllegalStateException("Maximum time limit in milliseconds not set");
        }
        return maxTimeMsec;
    }

    public void setMaxTimeMsec(long maxTimeMsec) {
        this.setMaxTime(Duration.ofMillis(maxTimeMsec));
    }

    public void setMaxTime(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        this.setValue(MetaKey.MAX_TIME_MS.key, timeout.toMillis());
    }

    public boolean hasComment() {
        return StringUtils.hasText((String)this.getComment());
    }

    public @Nullable String getComment() {
        return (String)this.getValue(MetaKey.COMMENT.key);
    }

    public String getRequiredComment() {
        String comment = this.getComment();
        if (comment == null) {
            throw new IllegalStateException("Comment not set");
        }
        return comment;
    }

    public void setComment(String comment) {
        this.setValue(MetaKey.COMMENT.key, comment);
    }

    public @Nullable Integer getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    public void setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
    }

    public boolean addFlag(CursorOption option) {
        Assert.notNull((Object)((Object)option), (String)"CursorOption must not be null");
        if (this.flags == Collections.EMPTY_SET) {
            this.flags = new LinkedHashSet<CursorOption>(2);
        }
        return this.flags.add(option);
    }

    public Set<CursorOption> getFlags() {
        return this.flags;
    }

    public @Nullable Boolean getAllowDiskUse() {
        return this.diskUse.equals((Object)DiskUse.DEFAULT) ? null : Boolean.valueOf(this.diskUse.equals((Object)DiskUse.ALLOW));
    }

    public void setAllowDiskUse(@Nullable Boolean allowDiskUse) {
        this.setDiskUse(DiskUse.of(allowDiskUse));
    }

    public void setDiskUse(DiskUse diskUse) {
        Assert.notNull((Object)((Object)diskUse), (String)"DiskUse must not be null");
        this.diskUse = diskUse;
    }

    public boolean hasValues() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.values.isEmpty() && this.flags.isEmpty() && this.cursorBatchSize == null && this.diskUse.equals((Object)DiskUse.DEFAULT);
    }

    public Iterable<Map.Entry<String, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    void setValue(String key, @Nullable Object value) {
        String stringValue;
        Assert.hasText((String)key, (String)"Meta key must not be 'null' or blank");
        if (this.values == Collections.EMPTY_MAP) {
            this.values = new LinkedHashMap<String, Object>(2);
        }
        if (value == null || value instanceof String && !StringUtils.hasText((String)(stringValue = (String)value))) {
            this.values.remove(key);
        }
        this.values.put(key, value);
    }

    private <T> @Nullable T getValue(String key) {
        return (T)this.values.get(key);
    }

    private <T> T getValue(String key, T defaultValue) {
        T value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public int hashCode() {
        int hash = ObjectUtils.nullSafeHashCode(this.values);
        hash += ObjectUtils.nullSafeHashCode(this.flags);
        hash += ObjectUtils.nullSafeHashCode((Object)this.cursorBatchSize);
        return hash += ObjectUtils.nullSafeHashCode((Object)((Object)this.diskUse));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)obj;
        if (!ObjectUtils.nullSafeEquals(this.values, other.values)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.flags, other.flags)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.cursorBatchSize, (Object)other.cursorBatchSize)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)((Object)this.diskUse), (Object)((Object)other.diskUse));
    }

    private static enum MetaKey {
        MAX_TIME_MS("$maxTimeMS"),
        MAX_SCAN("$maxScan"),
        COMMENT("$comment"),
        SNAPSHOT("$snapshot");

        private final String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }

    public static enum CursorOption {
        NO_TIMEOUT,
        EXHAUST,
        SECONDARY_READS,
        PARTIAL;

    }
}

