/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.client.model.MapReduceAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Contract;

@Deprecated
public class MapReduceOptions {
    private @Nullable String outputCollection;
    private Optional<String> outputDatabase = Optional.empty();
    private @Nullable MapReduceAction mapReduceAction = MapReduceAction.REPLACE;
    private Map<String, Object> scopeVariables = new HashMap<String, Object>();
    private Map<String, Object> extraOptions = new HashMap<String, Object>();
    private @Nullable Boolean jsMode;
    private Boolean verbose = Boolean.TRUE;
    private @Nullable Integer limit;
    private Optional<String> finalizeFunction = Optional.empty();
    private Optional<Collation> collation = Optional.empty();

    public static MapReduceOptions options() {
        return new MapReduceOptions();
    }

    @Contract(value="_ -> this")
    public MapReduceOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions outputCollection(String collectionName) {
        this.outputCollection = collectionName;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions outputDatabase(@Nullable String outputDatabase) {
        this.outputDatabase = Optional.ofNullable(outputDatabase);
        return this;
    }

    @Contract(value="-> this")
    public MapReduceOptions actionInline() {
        this.mapReduceAction = null;
        return this;
    }

    @Contract(value="-> this")
    public MapReduceOptions actionMerge() {
        this.mapReduceAction = MapReduceAction.MERGE;
        return this;
    }

    @Contract(value="-> this")
    public MapReduceOptions actionReduce() {
        this.mapReduceAction = MapReduceAction.REDUCE;
        return this;
    }

    @Contract(value="-> this")
    public MapReduceOptions actionReplace() {
        this.mapReduceAction = MapReduceAction.REPLACE;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions finalizeFunction(@Nullable String finalizeFunction) {
        this.finalizeFunction = Optional.ofNullable(finalizeFunction);
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions scopeVariables(Map<String, Object> scopeVariables) {
        this.scopeVariables = scopeVariables;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions javaScriptMode(boolean javaScriptMode) {
        this.jsMode = javaScriptMode;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Contract(value="_ -> this")
    public MapReduceOptions collation(@Nullable Collation collation) {
        this.collation = Optional.ofNullable(collation);
        return this;
    }

    public Optional<String> getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public @Nullable Boolean getJavaScriptMode() {
        return this.jsMode;
    }

    public @Nullable String getOutputCollection() {
        return this.outputCollection;
    }

    public Optional<String> getOutputDatabase() {
        return this.outputDatabase;
    }

    public Map<String, Object> getScopeVariables() {
        return this.scopeVariables;
    }

    public @Nullable Integer getLimit() {
        return this.limit;
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }

    public @Nullable MapReduceAction getMapReduceAction() {
        return this.mapReduceAction;
    }

    public boolean usesInlineOutput() {
        return null == this.mapReduceAction;
    }

    public Document getOptionsObject() {
        Document cmd = new Document();
        if (this.verbose != null) {
            cmd.put("verbose", (Object)this.verbose);
        }
        cmd.put("out", (Object)this.createOutObject());
        this.finalizeFunction.ifPresent(val -> cmd.append("finalize", val));
        if (this.scopeVariables != null) {
            cmd.put("scope", this.scopeVariables);
        }
        if (this.limit != null) {
            cmd.put("limit", (Object)this.limit);
        }
        if (!this.extraOptions.keySet().isEmpty()) {
            cmd.putAll(this.extraOptions);
        }
        this.getCollation().ifPresent(val -> cmd.append("collation", (Object)val.toDocument()));
        return cmd;
    }

    protected Document createOutObject() {
        Document out = new Document();
        if (this.getMapReduceAction() == null) {
            out.put("inline", (Object)1);
        } else {
            switch (this.getMapReduceAction()) {
                case REPLACE: {
                    out.put("replace", (Object)this.outputCollection);
                    break;
                }
                case MERGE: {
                    out.put("merge", (Object)this.outputCollection);
                    break;
                }
                case REDUCE: {
                    out.put("reduce", (Object)this.outputCollection);
                }
            }
        }
        this.outputDatabase.ifPresent(val -> out.append("db", val));
        return out;
    }
}

