/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.MongoTransactionOptions;
import org.springframework.util.Assert;

class SimpleMongoTransactionOptions
implements MongoTransactionOptions {
    static final Set<String> KNOWN_KEYS = Arrays.stream(OptionKey.values()).map(OptionKey::getKey).collect(Collectors.toSet());
    private final @Nullable Duration maxCommitTime;
    private final @Nullable ReadConcern readConcern;
    private final @Nullable ReadPreference readPreference;
    private final @Nullable WriteConcern writeConcern;

    static SimpleMongoTransactionOptions of(Map<String, String> options) {
        return new SimpleMongoTransactionOptions(options);
    }

    private SimpleMongoTransactionOptions(Map<String, String> options) {
        this.maxCommitTime = SimpleMongoTransactionOptions.doGetMaxCommitTime(options);
        this.readConcern = SimpleMongoTransactionOptions.doGetReadConcern(options);
        this.readPreference = SimpleMongoTransactionOptions.doGetReadPreference(options);
        this.writeConcern = SimpleMongoTransactionOptions.doGetWriteConcern(options);
    }

    @Override
    public @Nullable Duration getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public @Nullable ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public @Nullable ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public @Nullable WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public String toString() {
        return "DefaultMongoTransactionOptions{maxCommitTime=" + String.valueOf(this.maxCommitTime) + ", readConcern=" + String.valueOf(this.readConcern) + ", readPreference=" + String.valueOf(this.readPreference) + ", writeConcern=" + String.valueOf(this.writeConcern) + "}";
    }

    private static @Nullable Duration doGetMaxCommitTime(Map<String, String> options) {
        return (Duration)SimpleMongoTransactionOptions.getValue(options, OptionKey.MAX_COMMIT_TIME, value -> {
            Duration timeout = Duration.parse(value);
            Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"%s cannot be negative".formatted(new Object[]{OptionKey.MAX_COMMIT_TIME}));
            return timeout;
        });
    }

    private static @Nullable ReadConcern doGetReadConcern(Map<String, String> options) {
        return (ReadConcern)SimpleMongoTransactionOptions.getValue(options, OptionKey.READ_CONCERN, value -> new ReadConcern(ReadConcernLevel.fromString((String)value)));
    }

    private static @Nullable ReadPreference doGetReadPreference(Map<String, String> options) {
        return (ReadPreference)SimpleMongoTransactionOptions.getValue(options, OptionKey.READ_PREFERENCE, ReadPreference::valueOf);
    }

    private static @Nullable WriteConcern doGetWriteConcern(Map<String, String> options) {
        return (WriteConcern)SimpleMongoTransactionOptions.getValue(options, OptionKey.WRITE_CONCERN, value -> {
            WriteConcern writeConcern = WriteConcern.valueOf((String)value);
            if (writeConcern == null) {
                throw new IllegalArgumentException("'%s' is not a valid WriteConcern".formatted(options.get("writeConcern")));
            }
            return writeConcern;
        });
    }

    private static <T> @Nullable T getValue(Map<String, String> options, OptionKey key, Function<String, T> convertFunction) {
        String value = options.get(key.getKey());
        return (T)(value != null ? convertFunction.apply((Object)value) : null);
    }

    static enum OptionKey {
        MAX_COMMIT_TIME("maxCommitTime"),
        READ_CONCERN("readConcern"),
        READ_PREFERENCE("readPreference"),
        WRITE_CONCERN("writeConcern");

        final String key;

        private OptionKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }
    }
}

