/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.data.mongodb.TransactionMetadata;
import org.springframework.data.mongodb.core.ReadConcernAware;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.data.mongodb.core.WriteConcernAware;
import org.springframework.lang.Nullable;

public interface MongoTransactionOptions
extends TransactionMetadata,
ReadConcernAware,
ReadPreferenceAware,
WriteConcernAware {
    public static final MongoTransactionOptions NONE = new MongoTransactionOptions(){

        @Override
        @Nullable
        public Duration getMaxCommitTime() {
            return null;
        }

        @Override
        @Nullable
        public ReadConcern getReadConcern() {
            return null;
        }

        @Override
        @Nullable
        public ReadPreference getReadPreference() {
            return null;
        }

        @Override
        @Nullable
        public WriteConcern getWriteConcern() {
            return null;
        }
    };

    default public MongoTransactionOptions mergeWith(final @Nullable MongoTransactionOptions fallbackOptions) {
        if (fallbackOptions == null || NONE.equals(fallbackOptions)) {
            return this;
        }
        return new MongoTransactionOptions(){

            @Override
            @Nullable
            public Duration getMaxCommitTime() {
                return MongoTransactionOptions.this.hasMaxCommitTime() ? MongoTransactionOptions.this.getMaxCommitTime() : fallbackOptions.getMaxCommitTime();
            }

            @Override
            @Nullable
            public ReadConcern getReadConcern() {
                return MongoTransactionOptions.this.hasReadConcern() ? MongoTransactionOptions.this.getReadConcern() : fallbackOptions.getReadConcern();
            }

            @Override
            @Nullable
            public ReadPreference getReadPreference() {
                return MongoTransactionOptions.this.hasReadPreference() ? MongoTransactionOptions.this.getReadPreference() : fallbackOptions.getReadPreference();
            }

            @Override
            @Nullable
            public WriteConcern getWriteConcern() {
                return MongoTransactionOptions.this.hasWriteConcern() ? MongoTransactionOptions.this.getWriteConcern() : fallbackOptions.getWriteConcern();
            }
        };
    }

    default public <T> T map(Function<MongoTransactionOptions, T> mappingFunction) {
        return mappingFunction.apply(this);
    }

    @Nullable
    default public TransactionOptions toDriverOptions() {
        return this.map(it -> {
            if (NONE.equals(it)) {
                return null;
            }
            TransactionOptions.Builder builder = TransactionOptions.builder();
            if (it.hasMaxCommitTime()) {
                builder.maxCommitTime(Long.valueOf(it.getMaxCommitTime().toMillis()), TimeUnit.MILLISECONDS);
            }
            if (it.hasReadConcern()) {
                builder.readConcern(it.getReadConcern());
            }
            if (it.hasReadPreference()) {
                builder.readPreference(it.getReadPreference());
            }
            if (it.hasWriteConcern()) {
                builder.writeConcern(it.getWriteConcern());
            }
            return builder.build();
        });
    }

    public static MongoTransactionOptions of(final @Nullable TransactionOptions options) {
        if (options == null) {
            return NONE;
        }
        return new MongoTransactionOptions(){

            @Override
            @Nullable
            public Duration getMaxCommitTime() {
                Long millis = options.getMaxCommitTime(TimeUnit.MILLISECONDS);
                return millis != null ? Duration.ofMillis(millis) : null;
            }

            @Override
            @Nullable
            public ReadConcern getReadConcern() {
                return options.getReadConcern();
            }

            @Override
            @Nullable
            public ReadPreference getReadPreference() {
                return options.getReadPreference();
            }

            @Override
            @Nullable
            public WriteConcern getWriteConcern() {
                return options.getWriteConcern();
            }

            @Override
            @Nullable
            public TransactionOptions toDriverOptions() {
                return options;
            }
        };
    }
}

