/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.core.AggregationUtil;
import org.springframework.data.mongodb.core.EntityOperations;
import org.springframework.data.mongodb.core.HintFunction;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.PropertyOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.aggregation.RelaxedTypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoId;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class QueryOperations {
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final EntityOperations entityOperations;
    private final PropertyOperations propertyOperations;
    private final CodecRegistryProvider codecRegistryProvider;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final AggregationUtil aggregationUtil;
    private final Map<Class<?>, Document> mappedShardKey = new ConcurrentHashMap(1);

    QueryOperations(QueryMapper queryMapper, UpdateMapper updateMapper, EntityOperations entityOperations, PropertyOperations propertyOperations, CodecRegistryProvider codecRegistryProvider) {
        this.queryMapper = queryMapper;
        this.updateMapper = updateMapper;
        this.entityOperations = entityOperations;
        this.propertyOperations = propertyOperations;
        this.codecRegistryProvider = codecRegistryProvider;
        this.mappingContext = queryMapper.getMappingContext();
        this.aggregationUtil = new AggregationUtil(queryMapper, this.mappingContext);
    }

    InsertContext createInsertContext(Document source) {
        return this.createInsertContext(MappedDocument.of(source));
    }

    InsertContext createInsertContext(MappedDocument mappedDocument) {
        return new InsertContext(mappedDocument);
    }

    QueryContext createQueryContext(Query query) {
        return new QueryContext(query);
    }

    DistinctQueryContext distinctQueryContext(Query query, String fieldName) {
        return new DistinctQueryContext(query, fieldName);
    }

    CountContext countQueryContext(Query query) {
        return new CountContext(query);
    }

    UpdateContext updateContext(UpdateDefinition updateDefinition, Query query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, true, upsert);
    }

    UpdateContext updateSingleContext(UpdateDefinition updateDefinition, Query query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, false, upsert);
    }

    UpdateContext updateSingleContext(UpdateDefinition updateDefinition, Document query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, false, upsert);
    }

    UpdateContext replaceSingleContext(MappedDocument replacement, boolean upsert) {
        return new UpdateContext(replacement, upsert);
    }

    UpdateContext replaceSingleContext(Query query, MappedDocument replacement, boolean upsert) {
        return new UpdateContext(query, replacement, upsert);
    }

    DeleteContext deleteQueryContext(Query query) {
        return new DeleteContext(query, true);
    }

    DeleteContext deleteSingleContext(Query query) {
        return new DeleteContext(query, false);
    }

    AggregationDefinition createAggregation(Aggregation aggregation, @Nullable Class<?> inputType) {
        return new AggregationDefinition(aggregation, inputType);
    }

    AggregationDefinition createAggregation(Aggregation aggregation, @Nullable AggregationOperationContext aggregationOperationContext) {
        return new AggregationDefinition(aggregation, aggregationOperationContext);
    }

    class InsertContext {
        private final MappedDocument source;

        private InsertContext(MappedDocument source) {
            this.source = source;
        }

        <T> MappedDocument prepareId(Class<T> type) {
            return this.prepareId((MongoPersistentEntity)QueryOperations.this.mappingContext.getPersistentEntity(type));
        }

        <T> MappedDocument prepareId(@Nullable MongoPersistentEntity<T> entity) {
            if (entity == null || this.source.hasId()) {
                return this.source;
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
            if (idProperty != null && (idProperty.hasExplicitWriteTarget() || idProperty.isAnnotationPresent(MongoId.class)) && !ClassUtils.isAssignable(ObjectId.class, idProperty.getFieldType())) {
                this.source.updateId(QueryOperations.this.queryMapper.convertId(new ObjectId(), idProperty.getFieldType()));
            }
            return this.source;
        }
    }

    class QueryContext {
        private final Query query;

        private QueryContext(Query query) {
            this.query = query != null ? query : new Query();
        }

        Query getQuery() {
            return this.query;
        }

        Document getQueryObject() {
            return this.query.getQueryObject();
        }

        <T> Document getMappedQuery(@Nullable Class<T> domainType, Function<Class<T>, MongoPersistentEntity<?>> entityLookup) {
            return this.getMappedQuery(domainType == null ? null : entityLookup.apply(domainType));
        }

        <T> Document getMappedQuery(@Nullable MongoPersistentEntity<T> entity) {
            return QueryOperations.this.queryMapper.getMappedObject((Bson)this.getQueryObject(), entity);
        }

        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity, EntityProjection<?, ?> projection) {
            Document mappedFields;
            Document fields = this.evaluateFields(entity);
            if (entity == null) {
                return fields;
            }
            if (!fields.isEmpty()) {
                mappedFields = QueryOperations.this.queryMapper.getMappedFields(fields, entity);
            } else {
                mappedFields = QueryOperations.this.propertyOperations.computeMappedFieldsForProjection(projection, fields);
                mappedFields = QueryOperations.this.queryMapper.addMetaAttributes(mappedFields, entity);
            }
            if (entity.hasTextScoreProperty() && mappedFields.containsKey((Object)entity.getTextScoreProperty().getFieldName()) && !this.query.getQueryObject().containsKey((Object)"$text")) {
                mappedFields.remove((Object)entity.getTextScoreProperty().getFieldName());
            }
            if (mappedFields.isEmpty()) {
                return BsonUtils.EMPTY_DOCUMENT;
            }
            return mappedFields;
        }

        private Document evaluateFields(@Nullable MongoPersistentEntity<?> entity) {
            Document fields = this.query.getFieldsObject();
            if (fields.isEmpty()) {
                return BsonUtils.EMPTY_DOCUMENT;
            }
            Document evaluated = new Document();
            for (Map.Entry entry : fields.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof MongoExpression) {
                    MongoExpression mongoExpression = (MongoExpression)v;
                    AggregationOperationContext ctx = entity == null ? Aggregation.DEFAULT_CONTEXT : new RelaxedTypeBasedAggregationOperationContext(entity.getType(), QueryOperations.this.mappingContext, QueryOperations.this.queryMapper);
                    evaluated.put((String)entry.getKey(), (Object)AggregationExpression.from(mongoExpression).toDocument(ctx));
                    continue;
                }
                evaluated.put((String)entry.getKey(), entry.getValue());
            }
            return evaluated;
        }

        Document getMappedSort(@Nullable MongoPersistentEntity<?> entity) {
            return QueryOperations.this.queryMapper.getMappedSort(this.query.getSortObject(), entity);
        }

        void applyCollation(@Nullable Class<?> domainType, Consumer<com.mongodb.client.model.Collation> consumer) {
            this.getCollation(domainType).ifPresent(consumer);
        }

        Optional<com.mongodb.client.model.Collation> getCollation(@Nullable Class<?> domainType) {
            return QueryOperations.this.entityOperations.forType(domainType).getCollation(this.query).map(Collation::toMongoCollation);
        }

        HintFunction getHintFunction() {
            return HintFunction.from(this.query.getHint());
        }

        <R> void applyHint(Function<String, R> stringConsumer, Function<Bson, R> bsonConsumer) {
            this.getHintFunction().ifPresent(QueryOperations.this.codecRegistryProvider, stringConsumer, bsonConsumer);
        }
    }

    class DistinctQueryContext
    extends QueryContext {
        private final String fieldName;

        private DistinctQueryContext(Object query, String fieldName) {
            Query query2;
            if (query instanceof Document) {
                Document document = (Document)query;
                query2 = new BasicQuery(document);
            } else {
                query2 = (Query)query;
            }
            super(query2);
            this.fieldName = fieldName;
        }

        @Override
        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity, EntityProjection<?, ?> projection) {
            return this.getMappedFields(entity);
        }

        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity) {
            return QueryOperations.this.queryMapper.getMappedFields(new Document(this.fieldName, (Object)1), entity);
        }

        String getMappedFieldName(@Nullable MongoPersistentEntity<?> entity) {
            return (String)this.getMappedFields(entity).keySet().iterator().next();
        }

        <T> Class<T> getDriverCompatibleClass(Class<T> type) {
            return QueryOperations.this.codecRegistryProvider.getCodecFor(type).map(Encoder::getEncoderClass).orElse(BsonValue.class);
        }

        Class<?> getMostSpecificConversionTargetType(Class<?> requestedTargetType, Class<?> domainType) {
            Class conversionTargetType = requestedTargetType;
            try {
                Class propertyType = PropertyPath.from((String)this.fieldName, domainType).getLeafProperty().getLeafType();
                if (ClassUtils.isAssignable(requestedTargetType, (Class)propertyType)) {
                    conversionTargetType = propertyType;
                }
            }
            catch (PropertyReferenceException propertyReferenceException) {
                // empty catch block
            }
            return conversionTargetType;
        }
    }

    class CountContext
    extends QueryContext {
        CountContext(Query query) {
            super(query);
        }

        CountOptions getCountOptions(@Nullable Class<?> domainType) {
            return this.getCountOptions(domainType, null);
        }

        CountOptions getCountOptions(@Nullable Class<?> domainType, @Nullable Consumer<CountOptions> callback) {
            HintFunction hintFunction;
            Meta meta;
            CountOptions options = new CountOptions();
            Query query = this.getQuery();
            this.applyCollation(domainType, arg_0 -> ((CountOptions)options).collation(arg_0));
            if (query.getLimit() > 0) {
                options.limit(query.getLimit());
            }
            if (query.getSkip() > 0L) {
                options.skip((int)query.getSkip());
            }
            if ((meta = query.getMeta()).hasValues()) {
                if (meta.hasMaxTime()) {
                    options.maxTime(meta.getRequiredMaxTimeMsec().longValue(), TimeUnit.MILLISECONDS);
                }
                if (meta.hasComment()) {
                    options.comment(meta.getComment());
                }
            }
            if ((hintFunction = HintFunction.from(query.getHint())).isPresent()) {
                options = hintFunction.apply(QueryOperations.this.codecRegistryProvider, arg_0 -> ((CountOptions)options).hintString(arg_0), arg_0 -> ((CountOptions)options).hint(arg_0));
            }
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }
    }

    class UpdateContext
    extends QueryContext {
        private final boolean multi;
        private final boolean upsert;
        @Nullable
        private final UpdateDefinition update;
        @Nullable
        private final MappedDocument mappedDocument;

        UpdateContext(UpdateDefinition update, Document query, boolean multi, boolean upsert) {
            this(update, new BasicQuery(query), multi, upsert);
        }

        UpdateContext(@Nullable UpdateDefinition update, Query query, boolean multi, boolean upsert) {
            super(query);
            this.multi = multi;
            this.upsert = upsert;
            this.update = update;
            this.mappedDocument = null;
        }

        UpdateContext(MappedDocument update, boolean upsert) {
            this(new BasicQuery(BsonUtils.asDocument(update.getIdFilter())), update, upsert);
        }

        UpdateContext(Query query, MappedDocument update, boolean upsert) {
            super(query);
            this.multi = false;
            this.upsert = upsert;
            this.mappedDocument = update;
            this.update = null;
        }

        UpdateOptions getUpdateOptions(@Nullable Class<?> domainType) {
            return this.getUpdateOptions(domainType, null);
        }

        UpdateOptions getUpdateOptions(@Nullable Class<?> domainType, @Nullable Query query) {
            UpdateOptions options = new UpdateOptions();
            options.upsert(this.upsert);
            if (this.update != null && this.update.hasArrayFilters()) {
                options.arrayFilters(this.update.getArrayFilters().stream().map(UpdateDefinition.ArrayFilter::asDocument).collect(Collectors.toList()));
            }
            if (query != null && query.isSorted()) {
                options.sort((Bson)this.getMappedSort(domainType != null ? (MongoPersistentEntity)QueryOperations.this.mappingContext.getPersistentEntity(domainType) : null));
            }
            HintFunction.from(this.getQuery().getHint()).ifPresent(QueryOperations.this.codecRegistryProvider, arg_0 -> ((UpdateOptions)options).hintString(arg_0), arg_0 -> ((UpdateOptions)options).hint(arg_0));
            this.applyCollation(domainType, arg_0 -> ((UpdateOptions)options).collation(arg_0));
            return options;
        }

        ReplaceOptions getReplaceOptions(@Nullable Class<?> domainType) {
            return this.getReplaceOptions(domainType, null);
        }

        ReplaceOptions getReplaceOptions(@Nullable Class<?> domainType, @Nullable Consumer<ReplaceOptions> callback) {
            UpdateOptions updateOptions = this.getUpdateOptions(domainType);
            ReplaceOptions options = new ReplaceOptions();
            options.collation(updateOptions.getCollation());
            options.upsert(updateOptions.isUpsert());
            this.applyHint(arg_0 -> ((ReplaceOptions)options).hintString(arg_0), arg_0 -> ((ReplaceOptions)options).hint(arg_0));
            if (!this.isMulti() && this.getQuery().isSorted()) {
                options.sort((Bson)this.getMappedSort(domainType != null ? (MongoPersistentEntity)QueryOperations.this.mappingContext.getPersistentEntity(domainType) : null));
            }
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }

        @Override
        <T> Document getMappedQuery(@Nullable MongoPersistentEntity<T> domainType) {
            return this.applyIsolation(super.getMappedQuery(domainType));
        }

        Document getReplacementQuery() {
            return this.applyIsolation(this.getQueryObject());
        }

        private Document applyIsolation(Document mappedQuery) {
            if (this.multi && this.update != null && this.update.isIsolated().booleanValue() && !mappedQuery.containsKey((Object)"$isolated")) {
                mappedQuery = new Document((Map)mappedQuery);
                mappedQuery.put("$isolated", (Object)1);
            }
            return mappedQuery;
        }

        <T> Document applyShardKey(MongoPersistentEntity<T> domainType, Document filter, @Nullable Document existing) {
            Document shardKeySource = existing != null ? existing : (this.mappedDocument != null ? this.mappedDocument.getDocument() : this.getMappedUpdate(domainType));
            Document filterWithShardKey = new Document((Map)filter);
            this.getMappedShardKeyFields(domainType).forEach(key -> filterWithShardKey.putIfAbsent(key, BsonUtils.resolveValue((Bson)shardKeySource, key)));
            return filterWithShardKey;
        }

        boolean requiresShardKey(Document filter, @Nullable MongoPersistentEntity<?> domainType) {
            return !this.multi && domainType != null && domainType.isSharded() && !this.shardedById(domainType) && !filter.keySet().containsAll(this.getMappedShardKeyFields(domainType));
        }

        private boolean shardedById(MongoPersistentEntity<?> domainType) {
            ShardKey shardKey = domainType.getShardKey();
            if (shardKey.size() != 1) {
                return false;
            }
            String key = shardKey.getPropertyNames().iterator().next();
            if (FieldName.ID.name().equals(key)) {
                return true;
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)domainType.getIdProperty();
            return idProperty != null && idProperty.getName().equals(key);
        }

        Set<String> getMappedShardKeyFields(MongoPersistentEntity<?> entity) {
            return this.getMappedShardKey(entity).keySet();
        }

        Document getMappedShardKey(MongoPersistentEntity<?> entity) {
            return QueryOperations.this.mappedShardKey.computeIfAbsent(entity.getType(), key -> QueryOperations.this.queryMapper.getMappedFields(entity.getShardKey().getDocument(), entity));
        }

        List<Document> getUpdatePipeline(@Nullable Class<?> domainType) {
            Class<Object> type = domainType != null ? domainType : Object.class;
            RelaxedTypeBasedAggregationOperationContext context = new RelaxedTypeBasedAggregationOperationContext(type, QueryOperations.this.mappingContext, QueryOperations.this.queryMapper);
            return QueryOperations.this.aggregationUtil.createPipeline((AggregationUpdate)this.update, context);
        }

        Document getMappedUpdate(@Nullable MongoPersistentEntity<?> entity) {
            if (this.update != null) {
                return this.update instanceof MappedDocument.MappedUpdate ? this.update.getUpdateObject() : QueryOperations.this.updateMapper.getMappedObject((Bson)this.update.getUpdateObject(), entity);
            }
            return this.mappedDocument.getDocument();
        }

        void increaseVersionForUpdateIfNecessary(@Nullable MongoPersistentEntity<?> persistentEntity) {
            if (persistentEntity != null && persistentEntity.hasVersionProperty()) {
                String versionFieldName = ((MongoPersistentProperty)persistentEntity.getRequiredVersionProperty()).getFieldName();
                if (this.update != null && !this.update.modifies(versionFieldName)) {
                    this.update.inc(versionFieldName);
                }
            }
        }

        boolean isAggregationUpdate() {
            return this.update instanceof AggregationUpdate;
        }

        boolean isMulti() {
            return this.multi;
        }
    }

    class DeleteContext
    extends QueryContext {
        private final boolean multi;

        DeleteContext(Query query, boolean multi) {
            super(query);
            this.multi = multi;
        }

        DeleteOptions getDeleteOptions(@Nullable Class<?> domainType) {
            return this.getDeleteOptions(domainType, null);
        }

        DeleteOptions getDeleteOptions(@Nullable Class<?> domainType, @Nullable Consumer<DeleteOptions> callback) {
            DeleteOptions options = new DeleteOptions();
            this.applyCollation(domainType, arg_0 -> ((DeleteOptions)options).collation(arg_0));
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }

        boolean isMulti() {
            return this.multi;
        }
    }

    class AggregationDefinition {
        private final Aggregation aggregation;
        private final Lazy<AggregationOperationContext> aggregationOperationContext;
        private final Lazy<List<Document>> pipeline;
        @Nullable
        private final Class<?> inputType;

        AggregationDefinition(@Nullable Aggregation aggregation, AggregationOperationContext aggregationOperationContext) {
            this.aggregation = aggregation;
            if (aggregation instanceof TypedAggregation) {
                TypedAggregation typedAggregation = (TypedAggregation)aggregation;
                this.inputType = typedAggregation.getInputType();
            } else if (aggregationOperationContext instanceof TypeBasedAggregationOperationContext) {
                TypeBasedAggregationOperationContext typeBasedAggregationOperationContext = (TypeBasedAggregationOperationContext)aggregationOperationContext;
                this.inputType = typeBasedAggregationOperationContext.getType();
            } else {
                this.inputType = null;
            }
            this.aggregationOperationContext = Lazy.of(() -> aggregationOperationContext != null ? aggregationOperationContext : QueryOperations.this.aggregationUtil.createAggregationContext(aggregation, this.getInputType()));
            this.pipeline = Lazy.of(() -> QueryOperations.this.aggregationUtil.createPipeline(this.aggregation, this.getAggregationOperationContext()));
        }

        AggregationDefinition(@Nullable Aggregation aggregation, Class<?> inputType) {
            this.aggregation = aggregation;
            if (aggregation instanceof TypedAggregation) {
                TypedAggregation typedAggregation = (TypedAggregation)aggregation;
                this.inputType = typedAggregation.getInputType();
            } else {
                this.inputType = inputType;
            }
            this.aggregationOperationContext = Lazy.of(() -> QueryOperations.this.aggregationUtil.createAggregationContext(aggregation, this.getInputType()));
            this.pipeline = Lazy.of(() -> QueryOperations.this.aggregationUtil.createPipeline(this.aggregation, this.getAggregationOperationContext()));
        }

        List<Document> getAggregationPipeline() {
            return (List)this.pipeline.get();
        }

        boolean isOutOrMerge() {
            return this.aggregation.getPipeline().isOutOrMerge();
        }

        AggregationOperationContext getAggregationOperationContext() {
            return (AggregationOperationContext)this.aggregationOperationContext.get();
        }

        @Nullable
        Class<?> getInputType() {
            return this.inputType;
        }
    }
}

