/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map.repository.config;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.QueryEngineFactory;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.map.KeySpaceStore;
import org.springframework.data.map.MapKeyValueAdapter;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.ClassUtils;

public class MapRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    @Override
    public String getModuleName() {
        return "Map";
    }

    @Override
    protected String getModulePrefix() {
        return "map";
    }

    @Override
    protected String getDefaultKeyValueTemplateRef() {
        return "mapKeyValueTemplate";
    }

    @Override
    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.rootBeanDefinition(MapKeyValueAdapter.class);
        adapterBuilder.addConstructorArgValue(MapRepositoryConfigurationExtension.getKeySpaceStore(configurationSource));
        SortAccessor<?> sortAccessor = MapRepositoryConfigurationExtension.getSortAccessor(configurationSource);
        QueryEngine<?, ?, ?> queryEngine = MapRepositoryConfigurationExtension.getQueryEngine(sortAccessor, configurationSource);
        if (queryEngine != null) {
            adapterBuilder.addConstructorArgValue(queryEngine);
        } else if (sortAccessor != null) {
            adapterBuilder.addConstructorArgValue(sortAccessor);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(KeyValueTemplate.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)adapterBuilder, (Object)configurationSource.getSource()));
        builder.setRole(1);
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)builder, (Object)configurationSource.getSource());
    }

    private static Object getKeySpaceStore(RepositoryConfigurationSource source) {
        Optional keySpaceStoreRef = source.getAttribute("keySpaceStoreRef", String.class);
        return keySpaceStoreRef.map(beanName -> new RuntimeBeanReference(beanName, KeySpaceStore.class)).map(Object.class::cast).orElseGet(() -> source.getRequiredAttribute("mapType", Class.class));
    }

    private static @Nullable SortAccessor<?> getSortAccessor(RepositoryConfigurationSource source) {
        Class sortAccessorType = MapRepositoryConfigurationExtension.getClassAttribute(source, "sortAccessor");
        if (sortAccessorType == null) {
            return null;
        }
        return (SortAccessor)BeanUtils.instantiateClass(sortAccessorType);
    }

    private static @Nullable QueryEngine<?, ?, ?> getQueryEngine(@Nullable SortAccessor<?> sortAccessor, RepositoryConfigurationSource source) {
        Constructor constructor;
        Class queryEngineFactoryType = MapRepositoryConfigurationExtension.getClassAttribute(source, "queryEngineFactory");
        if (queryEngineFactoryType == null) {
            return null;
        }
        if (sortAccessor != null && (constructor = ClassUtils.getConstructorIfAvailable(queryEngineFactoryType, (Class[])new Class[]{SortAccessor.class})) != null) {
            return ((QueryEngineFactory)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{sortAccessor})).create();
        }
        return ((QueryEngineFactory)BeanUtils.instantiateClass(queryEngineFactoryType)).create();
    }

    private static <T> @Nullable Class<T> getClassAttribute(RepositoryConfigurationSource source, String attributeName) {
        return source.getAttribute(attributeName, Class.class).filter(Predicate.not(Class::isInterface)).orElse(null);
    }
}

