/*
 * Copyright 2024-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;

import org.springframework.data.domain.Sort;

/**
 * Strategy interface that allows implementations to create JPQL queries providing details about parameter bindings and
 * the selection mechanism.
 *
 * @author Mark Paluch
 * @since 4.0
 */
interface JpqlQueryCreator {

	/**
	 * @return whether the query uses a tuple query.
	 */
	boolean useTupleQuery();

	/**
	 * Create the JPQL query applying {@link Sort}.
	 *
	 * @param sort the sort order, can be {@link Sort#unsorted()}.
	 * @return the rendered JPQL query.
	 */
	String createQuery(Sort sort);

	/*
	 * @return the parameter bindings.
	 */
	List<ParameterBinding> getBindings();

	/**
	 * @return parameter binder to use to bind parameters.
	 */
	ParameterBinder getBinder();

}
