/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DtoProjectionTransformerDelegate;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryRenderer;
import org.springframework.data.jpa.repository.query.JpaQueryTransformerSupport;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;

class EqlSortedQueryTransformer
extends EqlQueryRenderer {
    private final JpaQueryTransformerSupport transformerSupport = new JpaQueryTransformerSupport();
    private final Sort sort;
    @Nullable
    private final String primaryFromAlias;
    @Nullable
    private final DtoProjectionTransformerDelegate dtoDelegate;

    EqlSortedQueryTransformer(Sort sort, QueryInformation queryInformation, @Nullable ReturnedType returnedType) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull((Object)queryInformation, (String)"ParsedHqlQueryInformation must not be null");
        this.sort = sort;
        this.primaryFromAlias = queryInformation.getAlias();
        this.dtoDelegate = returnedType == null ? null : new DtoProjectionTransformerDelegate(returnedType);
    }

    @Override
    public QueryTokenStream visitSelectQuery(EqlParser.SelectQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.set_fuction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.set_fuction()));
        } else {
            this.doVisitOrderBy(builder, ctx.orderby_clause());
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromQuery(EqlParser.FromQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.set_fuction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.set_fuction()));
        } else {
            this.doVisitOrderBy(builder, ctx.orderby_clause());
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        if (this.dtoDelegate == null) {
            return super.visitSelect_clause(ctx);
        }
        QueryRenderer.QueryRendererBuilder builder = this.prepareSelectClause(ctx);
        QueryTokenStream selectItems = QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((EqlSortedQueryTransformer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
        if (this.dtoDelegate != null && this.dtoDelegate.canRewrite()) {
            builder.append(this.dtoDelegate.getRewrittenSelectionList());
        } else {
            builder.append(selectItems);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_item(EqlParser.Select_itemContext ctx) {
        QueryTokenStream tokens = (QueryTokenStream)super.visitSelect_item(ctx);
        if (ctx.result_variable() != null && !tokens.isEmpty()) {
            this.transformerSupport.registerAlias(ctx.result_variable().getText());
        }
        return tokens;
    }

    @Override
    public QueryTokenStream visitSelect_expression(EqlParser.Select_expressionContext ctx) {
        QueryTokenStream selectItem = super.visitSelect_expression(ctx);
        if (ctx.constructor_expression() == null && this.dtoDelegate != null && this.dtoDelegate.applyRewriting()) {
            this.dtoDelegate.appendSelectItem(selectItem);
        }
        return selectItem;
    }

    @Override
    public QueryTokenStream visitJoin(EqlParser.JoinContext ctx) {
        QueryTokenStream tokens = (QueryTokenStream)super.visitJoin(ctx);
        if (ctx.identification_variable() != null) {
            this.transformerSupport.registerAlias(ctx.identification_variable().getText());
        }
        return tokens;
    }

    private void doVisitOrderBy(QueryRenderer.QueryRendererBuilder builder, EqlParser.Orderby_clauseContext ctx) {
        if (ctx != null) {
            QueryTokenStream existingOrder = (QueryTokenStream)this.visit((ParseTree)ctx);
            if (this.sort.isSorted()) {
                builder.appendInline(existingOrder);
            } else {
                builder.append(existingOrder);
            }
        }
        if (this.sort.isSorted()) {
            List<QueryToken> sortBy = this.transformerSupport.orderBy(this.primaryFromAlias, this.sort);
            if (ctx != null) {
                QueryRenderer.QueryRendererBuilder extension = QueryRenderer.builder().append(QueryTokens.TOKEN_COMMA).append(sortBy);
                builder.appendInline(extension);
            } else {
                builder.append(QueryTokens.TOKEN_ORDER_BY);
                builder.append(sortBy);
            }
        }
    }
}

