/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.NativeQuery;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.aot.AotEntityGraph;
import org.springframework.data.jpa.repository.aot.AotMetamodel;
import org.springframework.data.jpa.repository.aot.AotQueries;
import org.springframework.data.jpa.repository.aot.AotRepositoryFragmentSupport;
import org.springframework.data.jpa.repository.aot.EntityGraphLookup;
import org.springframework.data.jpa.repository.aot.JpaCodeBlocks;
import org.springframework.data.jpa.repository.aot.QueriesFactory;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.TypeInformation;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryContributor
extends RepositoryContributor {
    private final Metamodel metamodel;
    private final PersistenceProvider persistenceProvider;
    private final QueriesFactory queriesFactory;
    private final EntityGraphLookup entityGraphLookup;
    private final AotRepositoryContext context;

    public JpaRepositoryContributor(AotRepositoryContext repositoryContext) {
        this(repositoryContext, new AotMetamodel(repositoryContext));
    }

    public JpaRepositoryContributor(AotRepositoryContext repositoryContext, PersistenceUnitInfo unitInfo) {
        this(repositoryContext, new AotMetamodel(unitInfo));
    }

    public JpaRepositoryContributor(AotRepositoryContext repositoryContext, PersistenceManagedTypes managedTypes) {
        this(repositoryContext, new AotMetamodel(managedTypes));
    }

    public JpaRepositoryContributor(AotRepositoryContext repositoryContext, EntityManagerFactory entityManagerFactory) {
        this(repositoryContext, entityManagerFactory.getMetamodel(), PersistenceProvider.fromEntityManagerFactory(entityManagerFactory), new QueriesFactory(repositoryContext.getConfigurationSource(), entityManagerFactory, repositoryContext.getRequiredClassLoader()), new EntityGraphLookup(entityManagerFactory));
    }

    private JpaRepositoryContributor(AotRepositoryContext repositoryContext, AotMetamodel metamodel) {
        this(repositoryContext, metamodel, PersistenceProvider.fromEntityManagerFactory(metamodel.getEntityManagerFactory()), new QueriesFactory(repositoryContext.getConfigurationSource(), metamodel.getEntityManagerFactory(), repositoryContext.getRequiredClassLoader()), new EntityGraphLookup(metamodel.getEntityManagerFactory()));
    }

    private JpaRepositoryContributor(AotRepositoryContext repositoryContext, Metamodel metamodel, PersistenceProvider persistenceProvider, QueriesFactory queriesFactory, EntityGraphLookup entityGraphLookup) {
        super(repositoryContext);
        this.metamodel = metamodel;
        this.persistenceProvider = persistenceProvider;
        this.queriesFactory = queriesFactory;
        this.entityGraphLookup = entityGraphLookup;
        this.context = repositoryContext;
    }

    protected void customizeClass(AotRepositoryClassBuilder classBuilder) {
        classBuilder.customize(builder -> {
            TypeSpec.Builder builder2 = builder.superclass(TypeName.get(AotRepositoryFragmentSupport.class));
        });
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder constructorBuilder) {
        String entityManagerFactoryRef = this.getEntityManagerFactoryRef();
        constructorBuilder.addParameter("entityManager", EntityManager.class, customizer -> customizer.bindToField().origin((BeanReference)(StringUtils.hasText((String)entityManagerFactoryRef) ? new RuntimeBeanReference(entityManagerFactoryRef, EntityManager.class) : new RuntimeBeanReference(EntityManager.class))));
        constructorBuilder.addParameter("context", RepositoryFactoryBeanSupport.FragmentCreationContext.class);
        Optional<Class<QueryEnhancerSelector>> queryEnhancerSelector = this.getQueryEnhancerSelectorClass();
        constructorBuilder.customize(builder -> {
            if (queryEnhancerSelector.isPresent()) {
                builder.addStatement("super(new T$(), context)", new Object[]{queryEnhancerSelector.get()});
            } else {
                builder.addStatement("super($T.DEFAULT_SELECTOR, context)", new Object[]{QueryEnhancerSelector.class});
            }
        });
    }

    private String getEntityManagerFactoryRef() {
        return this.context.getConfigurationSource().getAttribute("entityManagerFactoryRef").filter(it -> !"entityManagerFactory".equals(it)).orElse(null);
    }

    private Optional<Class<QueryEnhancerSelector>> getQueryEnhancerSelectorClass() {
        return this.context.getConfigurationSource().getAttribute("queryEnhancerSelector", Class.class).filter(it -> !it.equals(QueryEnhancerSelector.DefaultQueryEnhancerSelector.class));
    }

    @Nullable
    protected MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        JpaQueryMethod queryMethod = new JpaQueryMethod(method, (RepositoryMetadata)this.getRepositoryInformation(), this.getProjectionFactory(), this.persistenceProvider);
        Optional<Class<QueryEnhancerSelector>> queryEnhancerSelectorClass = this.getQueryEnhancerSelectorClass();
        QueryEnhancerSelector selector = queryEnhancerSelectorClass.map(BeanUtils::instantiateClass).orElse(QueryEnhancerSelector.DEFAULT_SELECTOR);
        if (queryMethod.isProcedureQuery()) {
            Procedure procedure = (Procedure)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Procedure.class);
            MethodContributor.QueryMethodMetadataContributorBuilder builder = MethodContributor.forQueryMethod((QueryMethod)queryMethod);
            if (procedure != null) {
                if (StringUtils.hasText((String)procedure.name())) {
                    return builder.metadataOnly((QueryMetadata)new NamedStoredProcedureMetadata(procedure.name()));
                }
                if (StringUtils.hasText((String)procedure.procedureName())) {
                    return builder.metadataOnly((QueryMetadata)new StoredProcedureMetadata(procedure.procedureName()));
                }
                if (StringUtils.hasText((String)procedure.value())) {
                    return builder.metadataOnly((QueryMetadata)new StoredProcedureMetadata(procedure.value()));
                }
            }
            return null;
        }
        ReturnedType returnedType = queryMethod.getResultProcessor().getReturnedType();
        JpaParameters parameters = queryMethod.getParameters();
        MergedAnnotation query = MergedAnnotations.from((AnnotatedElement)method).get(Query.class);
        AotQueries aotQueries = this.queriesFactory.createQueries(this.getRepositoryInformation(), returnedType, selector, (MergedAnnotation<Query>)query, queryMethod);
        if (parameters.hasScrollPositionParameter() || queryMethod.isScrollQuery()) {
            return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly(aotQueries.toMetadata(queryMethod.isPageQuery()));
        }
        if (parameters.hasDynamicProjection()) {
            return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly(aotQueries.toMetadata(queryMethod.isPageQuery()));
        }
        if (queryMethod.isModifyingQuery()) {
            TypeInformation returnType = this.getRepositoryInformation().getReturnType(method);
            boolean returnsCount = JpaCodeBlocks.QueryExecutionBlockBuilder.returnsModifying(returnType.getType());
            boolean isVoid = ClassUtils.isVoidType((Class)returnType.getType());
            if (!returnsCount && !isVoid) {
                return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly(aotQueries.toMetadata(queryMethod.isPageQuery()));
            }
        }
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata(aotQueries.toMetadata(queryMethod.isPageQuery())).contribute(context -> {
            CodeBlock.Builder body = CodeBlock.builder();
            MergedAnnotation nativeQuery = context.getAnnotation(NativeQuery.class);
            MergedAnnotation queryHints = context.getAnnotation(QueryHints.class);
            MergedAnnotation entityGraph = context.getAnnotation(EntityGraph.class);
            MergedAnnotation modifying = context.getAnnotation(Modifying.class);
            AotEntityGraph aotEntityGraph = this.entityGraphLookup.findEntityGraph((MergedAnnotation<EntityGraph>)entityGraph, this.getRepositoryInformation(), returnedType, queryMethod);
            body.add(JpaCodeBlocks.queryBuilder(context, queryMethod).filter(aotQueries).queryReturnType(QueriesFactory.getQueryReturnType(aotQueries.result(), returnedType, context)).nativeQuery((MergedAnnotation<NativeQuery>)nativeQuery).queryHints((MergedAnnotation<QueryHints>)queryHints).entityGraph(aotEntityGraph).queryRewriter(query.isPresent() ? query.getClass("queryRewriter") : null).build());
            body.add(JpaCodeBlocks.executionBuilder(context, queryMethod).modifying((MergedAnnotation<Modifying>)modifying).query(aotQueries.result()).build());
            return body.build();
        });
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    record NamedStoredProcedureMetadata(String procedureName) implements QueryMetadata
    {
        public Map<String, Object> serialize() {
            return Map.of("procedure-name", this.procedureName());
        }
    }

    record StoredProcedureMetadata(String procedure) implements QueryMetadata
    {
        public Map<String, Object> serialize() {
            return Map.of("procedure", this.procedure());
        }
    }
}

