/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.RowDocumentResultSetExtractor;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.jdbc.core.RowMapper;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private final TypeInformation<T> typeInformation;
    private final JdbcConverter converter;
    private final Identifier identifier;

    public EntityRowMapper(AggregatePath path, JdbcConverter converter, Identifier identifier) {
        this(path.getRequiredLeafEntity().getTypeInformation(), converter, identifier);
    }

    public EntityRowMapper(RelationalPersistentEntity<T> entity, JdbcConverter converter) {
        this(entity.getTypeInformation(), converter, Identifier.empty());
    }

    private EntityRowMapper(TypeInformation<T> typeInformation, JdbcConverter converter, Identifier identifier) {
        this.typeInformation = typeInformation;
        this.converter = converter;
        this.identifier = identifier;
    }

    public T mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
        RowDocument document = RowDocumentResultSetExtractor.toRowDocument(resultSet);
        return this.converter.readAndResolve(this.typeInformation, document, this.identifier);
    }
}

